<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers\Report;

use BPVMWP\Helpers\BpvmHelper;
use Xenioushk\BwlPluginApi\Api\Database\QueryManagerApi;

/**
 * Class for update voting data callback.
 *
 * @package BPVMWP
 */
class UpdateVoteCb {

	/**
	 * Update the vote.
	 */
	public function update() {

		// Initalize query manager API
		$data_table_query    = new QueryManagerApi( TABLE_BPVM_DATA );
		$summary_table_query = new QueryManagerApi( TABLE_BPVM_SUMMARY );

		// Set current date.
		$current_date = date( 'Y-m-d' );

		$post_id          = $_POST['post_id'];
		$post_type        = $_POST['post_type'];
		$pvm_mv_date      = $_POST['pvm_mv_date'];
		$pvm_mv_vote_type = intval( $_POST['pvm_mv_vote_type'] );
		$pvm_manual_votes = is_numeric( $_POST['pvm_manual_votes'] ) ? $_POST['pvm_manual_votes'] : 0;

		if ( $pvm_mv_vote_type === 1 ) {
			// Get the likes by date
			$liked_votes_by_date = get_post_meta( $post_id, 'pvm_liked_votes_by_date' );

			$liked_votes_by_date_info[] = ( ! empty( $liked_votes_by_date ) && is_array( $liked_votes_by_date ) ) ? $liked_votes_by_date[0] : [];

			if ( in_array( $current_date, array_keys( $liked_votes_by_date_info ), true ) ) {
				// store meta submission counter value.
				$liked_votes_by_date_counter               = $liked_votes_by_date[0][ $current_date ];
				$liked_votes_by_date_info[ $current_date ] = $liked_votes_by_date_counter + $pvm_manual_votes;

			} else {
				// if no one submitted voted yet, initialize pvm_submission_counter variable.
				$liked_votes_by_date_counter               = 0;
				$liked_votes_by_date_info[ $current_date ] = $liked_votes_by_date_counter + $pvm_manual_votes;
			}

			// Like Votes
			$like_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
			$total_likes       = ( ! $like_vote_counter ) ? $pvm_manual_votes : $like_vote_counter + $pvm_manual_votes;
			update_post_meta( $post_id, 'pvm_liked_votes_by_date', $liked_votes_by_date_info );
			update_post_meta( $post_id, 'pvm_like_votes_count', $total_likes );
			update_post_meta( $post_id, 'vote_date', $current_date );

		} elseif ( $pvm_mv_vote_type === 2 ) {

			// Get Disliked vote per date wise for the current post
			$disliked_votes_by_date = get_post_meta( $post_id, BPVM_DISLIKED_VOTES_BY_DATE );

			$disliked_votes_by_date_info[] = ( ! empty( $disliked_votes_by_date ) && is_array( $disliked_votes_by_date ) ) ? $disliked_votes_by_date[0] : [];

			if ( in_array( $current_date, array_keys( $disliked_votes_by_date_info ), true ) ) {
				// store meta submission counter value.
				$disliked_votes_by_date_counter               = $disliked_votes_by_date[0][ $current_date ];
				$disliked_votes_by_date_info[ $current_date ] = $disliked_votes_by_date_counter + $pvm_manual_votes;

			} else {
				// if no one submitted voted yet, initialize pvm_submission_counter variable.
				$disliked_votes_by_date_counter               = 0;
				$disliked_votes_by_date_info[ $current_date ] = $disliked_votes_by_date_counter + $pvm_manual_votes;
			}

			// Dislike Votes.
			$dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );
			$total_dislikes       = ( ! $dislike_vote_counter ) ? $pvm_manual_votes : $dislike_vote_counter + $pvm_manual_votes;
			update_post_meta( $post_id, BPVM_DISLIKED_VOTES_BY_DATE, $disliked_votes_by_date_info );
			update_post_meta( $post_id, BPVM_DISLIKE_VOTES_COUNT, $total_dislikes );
			update_post_meta( $post_id, BPVM_VOTE_DATE, $current_date );
		}

		// INSERT DATA IN TO SUMMARY TABLE
		$filters = [
			'postid'    => $post_id,
			'post_type' => $post_type,
			'vote_date' => $pvm_mv_date,
			'vote_type' => $pvm_mv_vote_type,
		];

		$args = [
			'page'            => 1, // for pagination support
			'per_page'        => 9999999, // large number to get all items
			'filters'         => $filters,
			'selected_fields' => 'id, total_votes,vote_type,vote_date',
			'order_by'        => 'vote_date',
			'order_dir'       => 'DESC',
		];

		$bpvm_voting_summary_data = $summary_table_query->get_items( $args );

		if ( count( $bpvm_voting_summary_data['data'] ) > 0 ) {

			// Update Summary table data.
			$prev_summary_data = $bpvm_voting_summary_data['data'];

			if ( ! empty( $prev_summary_data ) ) {

				$new_total_votes = intval( $prev_summary_data[0]['total_votes'] ?? 0 ) + intval( $pvm_manual_votes );
				$id              = $prev_summary_data[0]['id'] ?? 0;

				if ( $id ) {
					$updated_data = [
						'total_votes' => $new_total_votes,
					];

					$summary_table_query->update( $id, $updated_data );
				}
			}
		} else {

			// Insert new row in to summary table
			$summary_row_data = [
				'postid'      => $post_id,
				'post_type'   => $post_type,
				'vote_type'   => $pvm_mv_vote_type, // like=1, dislike=2
				'vote_date'   => $pvm_mv_date,
				'total_votes' => $pvm_manual_votes, // default is 1.
				'last_voted'  => $pvm_mv_date . ' ' . date( 'H:i:s' ),
			];

			$summary_table_query->insert( $summary_row_data );

		}

		// Insert new row in to data table
		$current_user = wp_get_current_user();

		$data_row_data = [
			'postid'    => $post_id,
			'post_type' => $post_type,
			'vote_type' => $pvm_mv_vote_type, // like=1, dislike=2
			'votes'     => $pvm_manual_votes, // default is 1.
			'vote_date' => $pvm_mv_date . ' ' . date( 'H:i:s' ),
			'voted_ip'  => $_SERVER['REMOTE_ADDR'],
			'user_id'   => $current_user->ID ?? 0,
		];

		$data_table_query->insert( $data_row_data );

		$post_data = [];

		$post_data['status'] = 1;

		// Added in version 1.1.4
		$total_likes    = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
		$total_dislikes = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

		update_post_meta( $post_id, 'pvm_total_votes', ( $total_likes + $total_dislikes ) );

		wp_send_json( $post_data );
	}
}
