<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers\Report;

use BPVMWP\Helpers\BpvmHelper;

/**
 * Class for getting single post data callback.
 *
 * @package BPVMWP
 */
class SinglePostDataCb {

	/**
	 * Get data.
	 */
	public function get_data() {

		$post_id   = $_POST['post_id'];
		$post_type = trim( $_POST['post_type'] );

		$like_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
		$total_likes       = ( $like_vote_counter == '' ) ? 0 : $like_vote_counter;

		$dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );
		$total_dislikes       = ( $dislike_vote_counter == '' ) ? 0 : $dislike_vote_counter;

		global $wpdb;

		$bpvm_voting_data_table = $wpdb->prefix . 'bpvm_data'; // for deatils. each day info.

		$order = 'DESC';

		$sql         = $wpdb->prepare(
            "SELECT* FROM {$bpvm_voting_data_table} 
                WHERE postid = %d 
                AND post_type = %s 
                ORDER BY vote_date DESC", $post_id, $post_type
		);
		$report_data = $wpdb->get_results( $sql );

		$post_data = [];

		$post_data['status'] = 1;
		$post_data['data']   = [
			'likes'       => $total_likes,
			'dislikes'    => $total_dislikes,
			'report_data' => $report_data,
		];

		echo json_encode( $post_data );

		wp_reset_query();  // reset the query

		die();
	}
}
