<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers\Report;

use WP_Query;

/**
 * Class for getting posts by post type.
 *
 * @package BPVMWP
 */
class PostTypeDataCb {

	/**
	 * Get the posts data by post type
	 */
	public function get_data() {

		$args = [
			'post_type'      => $_POST['post_type'],
			'posts_per_page' => -1,
			'orderby'        => 'title',
			'order'          => 'ASC',
		];

		$query = new WP_Query( $args );

		$post_data = [];

		if ( $query->have_posts() ) :
			while ( $query->have_posts() ) :
				$query->the_post();

				$post_data['status'] = 1;
				$post_data['data'][] = [
					'post_id'    => get_the_ID(),
					'post_title' => get_the_title(),
				];

		endwhile;

    else :
        $post_data['status'] = 0;
    endif;

    wp_reset_postdata();

		wp_send_json( $post_data );
	}
}
