<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers\Report;

use BPVMWP\Helpers\BpvmHelper;
/**
 * Class for item list callback.
 *
 * @package BPVMWP
 */
class DeleteVoteCb {

	/**
	 * Delete the vote.
	 */
	public function delete() {

		global $wpdb;
		$bpvm_voting_data_table    = TABLE_BPVM_DATA; // for deatils. each day info.
		$bpvm_voting_summary_table = TABLE_BPVM_SUMMARY; // daily summary.

		// GET POST DATA.

		$post_type       = $_POST['post_type'];
		$post_id         = $_POST['post_id'];
		$bpvm_data_stack = $_POST['bpvm_data_stack'];

		// Support For Undoing Vote.
		$bpvm_undo_vote = intval( $_POST['bpvm_undo_vote'] ?? 0 );

		// --------- ARRAY DATA STACK SEQUENCES ---------//
		// 0= row_id
		// 1=votes.
		// 2=vote_type
		// 3=vote_date

		$loop_counter = 0;
		foreach ( $bpvm_data_stack as $data_stack ) {
			++$loop_counter;

			$row_id           = $data_stack[0];
			$votes            = $data_stack[1];
			$pvm_mv_vote_type = $data_stack[2];
			$vote_date        = $data_stack[3];

			// -------- Start Remvoe Functions --------//

			if ( $pvm_mv_vote_type == 1 ) {

				// Like Votes

				$like_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
				$pre_total_likes   = ( $like_vote_counter == '' ) ? 0 : $like_vote_counter - $votes;
				$total_likes       = ( $pre_total_likes < 0 ) ? 0 : $pre_total_likes;
				update_post_meta( $post_id, 'pvm_like_votes_count', $total_likes );

			} elseif ( $pvm_mv_vote_type == 2 ) {

				// Dislike Votes.

				$dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );
				$pre_total_dislikes   = ( $dislike_vote_counter == '' ) ? 0 : $dislike_vote_counter - $votes;
				$total_dislikes       = ( $pre_total_dislikes < 0 ) ? 0 : $pre_total_dislikes;
				update_post_meta( $post_id, 'pvm_dislike_votes_count', $total_dislikes );
			}

			/* ------------------------------  GET DATA FROM SUMMARY TABLE. --------------------------------- */

			$sql                      = $wpdb->prepare(
                "SELECT id, total_votes FROM {$bpvm_voting_summary_table} 
                                            WHERE postid = %d 
                                            AND post_type = %s 
                                            AND vote_date = %s 
                                            AND vote_type = %d 
                                            ORDER BY vote_date DESC LIMIT 1", $post_id, $post_type, $vote_date, $pvm_mv_vote_type
			);
			$bpvm_voting_summary_data = $wpdb->get_results( $sql, ARRAY_A );

			if ( count( $bpvm_voting_summary_data ) > 0 ) {

				// Update Data

				$pre_total_votes = $bpvm_voting_summary_data[0]['total_votes'] - $votes;
				$new_total_votes = ( $pre_total_votes < 0 ) ? 0 : $pre_total_votes;

				$wpdb->update(
					$bpvm_voting_summary_table,
					[
						'total_votes' => $new_total_votes,
					], // Data – array of data to update as column->value pairs
					[ 'ID' => $bpvm_voting_summary_data[0]['id'] ], // Where – array of data to match as column->value pairs
					[ '%d' ], // Data Format
					[ '%d' ] // Where Format
				);

				if ( $pvm_mv_vote_type == 1 ) {

						// Again Update LikedPost Meta Table Values.
						$pvm_liked_votes_by_date_info               = [];
						$pvm_liked_votes_by_date_info[ $vote_date ] = $new_total_votes;
						update_post_meta( $post_id, 'pvm_liked_votes_by_date', $pvm_liked_votes_by_date_info );
				} elseif ( $pvm_mv_vote_type == 2 ) {

					// Again Update Disliked Post Meta Table Values.
					$pvm_disliked_votes_by_date_info               = [];
					$pvm_disliked_votes_by_date_info[ $vote_date ] = $new_total_votes;
					update_post_meta( $post_id, 'pvm_disliked_votes_by_date', $pvm_disliked_votes_by_date_info );
				}
			}

			// REMOVE DATA FROM VOTING DATA TABLE

			$wpdb->delete(
                $bpvm_voting_data_table,
                [ 'ID' => $row_id ],
                [ '%d' ] // Where Format
			);

			// -------- NEW:: Start Remvoe Functions --------//

			if ( $bpvm_undo_vote == 1 ) {

				/* --Reset Submission Counter-- */

				$meta_submission_counter = get_post_meta( $post_id, 'pvm_submission_counter' );  // Get no of submissions from a single IP address.

				$bpvm_user_IP = $_SERVER['REMOTE_ADDR'];

				if ( is_array( $meta_submission_counter[0] ) && array_key_exists( $bpvm_user_IP, $meta_submission_counter[0] ) ) {

					$pvm_old_submission_counter = $meta_submission_counter[0][ $bpvm_user_IP ];

					$pvm_new_submission_counter = ( $pvm_old_submission_counter > 0 ) ? ( $pvm_old_submission_counter - 1 ) : 0;

					$meta_submission_counter[0][ $bpvm_user_IP ] = $pvm_new_submission_counter;

					update_post_meta( $post_id, 'pvm_submission_counter', $meta_submission_counter[0] );
				}

				/* -- Remove Vote From User IP Address -- */

				$pvm_voted_ip = get_post_meta( $post_id, 'pvm_voted_ip' );  // Get no of submissions from a single IP address.

				if ( is_array( $pvm_voted_ip[0] ) && count( $pvm_voted_ip[0] ) > 1 ) {

					array_pop( $pvm_voted_ip[0] ); // remove the last id
					update_post_meta( $post_id, 'pvm_voted_ip', $pvm_voted_ip );
				}
			}
		}

		$post_data = [];

		$post_data['status']               = 1;
		$post_data['bpvm_data_stack']      = count( $bpvm_data_stack );
		$post_data['loop_counter']         = $loop_counter;
		$post_data['like_vote_counter']    = $like_vote_counter;
		$post_data['total_likes']          = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
		$post_data['dislike_vote_counter'] = $dislike_vote_counter;
		$post_data['total_dislikes']       = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

		// Added in version 1.1.4
		update_post_meta( $post_id, 'pvm_total_votes', ( $post_data['total_likes'] + $post_data['total_dislikes'] ) );

		wp_send_json( $post_data );
	}
}
