<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers;

use BPVMWP\Helpers\AdminHelpers;

/**
 * Class for registering the builk edit save callback.
 *
 * @package BPVMWP
 * @since: 1.0.0
 * @author: Mahbub Alam Khan
 */
class BulkEditSaveCb {

	/**
	 * Save data.
	 *
	 * @return mixed
	 */
	public function save_data() {

		// we need the post IDs
		$post_ids = ( isset( $_POST['post_ids'] ) && ! empty( $_POST['post_ids'] ) ) ? $_POST['post_ids'] : null;

		// if we have post IDs
		if ( ! empty( $post_ids ) && is_array( $post_ids ) ) {

			// get the custom fields

			$custom_fields = [ BPVM_VOTE_BOX_STATUS, BPVM_LIKE_VOTES_COUNT, BPVM_DISLIKE_VOTES_COUNT ];

			foreach ( $custom_fields as $field ) {

				// if it has a value, doesn't update if empty on bulk
				if ( isset( $_POST[ $field ] ) && trim( $_POST[ $field ] ) != '' ) {

					// update for each post ID
					foreach ( $post_ids as $post_id ) {

						update_post_meta( $post_id, $field, $_POST[ $field ] ); //phpcs:ignore

						// Clear All Data From Voting Summary & Voting Date Table
						if ( $field === BPVM_LIKE_VOTES_COUNT ) {

							// @ Added Like Votes Reset Feature & Fix Quick & Bulk Edit Issue
							// @ Since: version 1.1.1
							update_post_meta( $post_id, BPVM_LIKE_VOTES_COUNT, 0 );
							update_post_meta( $post_id, BPVM_LIKED_VOTES_BY_DATE, '' );
							update_post_meta( $post_id, BPVM_VOTED_IP, '' );
							update_post_meta( $post_id, BPVM_VOTE_DATE, '' );

							// @ Reset Like Votes In Custom Table Voting Data
							// @ Since: Version 1.1.0

							AdminHelpers::bpvm_reset_voting_data( get_post_type( $post_id ), $post_id, 1 );
						} elseif ( $field === BPVM_DISLIKE_VOTES_COUNT ) {

							// @ Added Disliked Votes Reset Feature & Fix Quick & Bulk Edit Issue
							// @ Since: version 1.1.1
							update_post_meta( $post_id, BPVM_DISLIKE_VOTES_COUNT, 0 );
							update_post_meta( $post_id, BPVM_DISLIKED_VOTES_BY_DATE, '' );
							update_post_meta( $post_id, BPVM_VOTED_IP, '' );
							update_post_meta( $post_id, BPVM_VOTE_DATE, '' );

							// @ Reset Disliked Votes In Custom Table Voting Data
							// @ Since: Version 1.1.0

							AdminHelpers::bpvm_reset_voting_data( get_post_type( $post_id ), $post_id, 2 );
						}
					}
				}
			}
		}
	}
}
