<?php
namespace BPVMWP\Callbacks\Actions\Admin\Scheduler;

/**
 * Class for registering all the schedulers.
 *
 * @package BPVMWP
 * @since: 1.0.0
 * @author: Mahbub Alam Khan
 */
class SchedulerCb {

	/**
	 * Set the cron schedule.
	 */
	public function register_cron_schedule() {
		// For Offers.
		// @check: Everyday
		if ( ! as_next_scheduled_action( BPVM_CRON_OFFER_ID ) ) {
			as_schedule_recurring_action( time(), BWL_CRON_EVERY_DAY, BPVM_CRON_OFFER_ID );
		}
		// For BWL Products.
		// @check: Every 1 Week

		if ( ! as_next_scheduled_action( BPVM_CRON_BWL_PRODUCTS_ID ) ) {
			as_schedule_recurring_action( time(), BWL_CRON_EVERY_WEEK, BPVM_CRON_BWL_PRODUCTS_ID );
		}
	}
}
