<?php
namespace BPVMWP\Callbacks\Actions\Admin;

/**
 * Class for registering the quick and bulk edit box.
 *
 * @package BPVMWP
 * @since: 1.0.0
 * @author: Mahbub Alam Khan
 */
class QuickBulkEditBoxCb {

	/**
	 * Callback for the quick edit custom box.
	 *
	 * @param string $column_name column name.
	 * @param string $post_type post type.
	 *
	 * @return mixed
	 */
	public function get_quick_bulk_edit_box( $column_name, $post_type ) {

		switch ( $post_type ) {

			case $post_type:
				switch ( $column_name ) {

					case BPVM_VOTE_BOX_STATUS:
						?>

<fieldset class="inline-edit-col-right">
    <div class="inline-edit-col">
    <div class="inline-edit-group">
        <label class="inline-edit-status alignleft">
        <span class="title"><?php esc_html_e( 'Voting Display Status', 'bwl-pro-voting-manager' ); ?></span>
        <select name="<?php echo BPVM_VOTE_BOX_STATUS; //phpcs:ignore ?>">
            <option value="">- <?php esc_html_e( 'Select', 'bwl-pro-voting-manager' ); ?> -</option>
            <option value="0"><?php esc_html_e( 'Hidden', 'bwl-pro-voting-manager' ); ?></option>
            <option value="1"><?php esc_html_e( 'Show', 'bwl-pro-voting-manager' ); ?></option>
            <option value="2"><?php esc_html_e( 'Closed', 'bwl-pro-voting-manager' ); ?></option>
            <option value="3"><?php esc_html_e( 'Paused', 'bwl-pro-voting-manager' ); ?></option>
            <option value="4"><?php esc_html_e( 'Date Range', 'bwl-pro-voting-manager' ); ?></option>
        </select>
        </label>
    </div>
    </div>
</fieldset>

						<?php

				        break;

					case BPVM_LIKE_VOTES_COUNT:
						?>

<fieldset class="inline-edit-col-right">
    <div class="inline-edit-col">
    <div class="inline-edit-group">
        <label class="alignleft">
        <input type="checkbox" value="0" name="<?php echo BPVM_LIKE_VOTES_COUNT; //phpcs:ignore ?>">
        <span class="checkbox-title"><?php esc_html_e( 'Reset Like Votes', 'bwl-pro-voting-manager' ); ?></span>
        </label>
    </div>
    </div>
</fieldset>

						<?php

                        break;

					case BPVM_DISLIKE_VOTES_COUNT:
						?>

<fieldset class="inline-edit-col-right">
    <div class="inline-edit-col">
    <div class="inline-edit-group">
        <label class="alignleft">
        <input type="checkbox" value="0" name="<?php echo BPVM_DISLIKE_VOTES_COUNT; //phpcs:ignore ?>">
        <span class="checkbox-title"><?php esc_html_e( 'Reset Dislike Votes', 'bwl-pro-voting-manager' ); ?></span>
        </label>
    </div>
    </div>
</fieldset>

						<?php

                        break;
				}

				break;
		}
	}
}
