<?php
namespace BPVMWP\Callbacks\ActionHandlers\Admin;

/**
 * Class for TinyMCE button callbacks.
 *
 * @package BPVMWP
 */
class TinyMceCb {

	/**
	 * The plugin slug.
	 *
	 * @var string
	 */

	private $btn_slug = 'bwl_pvm';

	/**
	 * Initalize the TinyMCE button.
	 */
	public function init_tiny_mce_button() {

		if ( current_user_can( 'edit_posts' ) && current_user_can( 'edit_pages' ) && get_user_option( 'rich_editing' ) == 'true' ) {

			add_filter( 'mce_external_plugins', [ $this, 'add_button_to_editor' ] );
			add_filter( 'mce_buttons', [ $this, 'register_shortcode_button' ] );
		}

	}

	/**
	 * Register the shortcode button.
	 *
	 * @param array $buttons The buttons array.
	 *
	 * @return array
	 */
	public function register_shortcode_button( $buttons ) {

		array_push( $buttons, $this->btn_slug );
		return $buttons;
	}

	/**
	 * Add the TinyMCE button to the editor.
	 *
	 * @param array $plugin_array The plugin array.
	 *
	 * @return array
	 */
	public function add_button_to_editor( $plugin_array ) {
		$plugin_array[ $this->btn_slug ] = BPVM_PLUGIN_LIBS_DIR . 'tinymce/scripts/bpvm_tinymce_button.js';
		return $plugin_array;
	}
}
