<?php
namespace BPVMWP\Callbacks\ActionHandlers\Admin;

/**
 * Class for Manage Vote Counts callbacks.
 *
 * @package BPVMWP
 */
class ManageVoteCountCb {

	/**
	 * Save the post vote count data.
	 *
	 * @param int $post_id The post ID.
	 */
	public function save_date( $post_id ) {

		global $post;

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {

			return $post_id;
		} else {

			$post_id = get_the_ID();

			$pvm_like_votes_count = get_post_meta( $post_id, BPVM_LIKE_VOTES_COUNT, true );

			if ( $pvm_like_votes_count == '' ) {

				// Update following post metas.

				update_post_meta( $post_id, BPVM_LIKE_VOTES_COUNT, 0 );
				update_post_meta( $post_id, BPVM_LIKED_VOTES_BY_DATE, '' );

				update_post_meta( $post_id, BPVM_DISLIKE_VOTES_COUNT, 0 );
				update_post_meta( $post_id, BPVM_DISLIKED_VOTES_BY_DATE, '' );

				update_post_meta( $post_id, BPVM_VOTED_IP, '' );
				update_post_meta( $post_id, BPVM_VOTE_DATE, '' );
				update_post_meta( $post_id, BPVM_TOTAL_VOTES, 0 );

				// Enter Deafult Voting data in to custom table.

				global $wpdb;
				// daily summary.
				$summary_table = TABLE_BPVM_SUMMARY;

				// Insert  Default Data

				$pvm_mv_date = date( 'Y-m-d' );
				$post_type   = get_post_type( $post_id );

				$pvm_mv_vote_type = 1; // for like
				$pvm_manual_votes = 0;

				$wpdb->insert(
                    $summary_table,
                    [
						'postid'      => $post_id,
						'post_type'   => $post_type,
						'vote_type'   => $pvm_mv_vote_type, // like=1, dislike=2
						'vote_date'   => $pvm_mv_date,
						'total_votes' => $pvm_manual_votes, // default is 1.
						'last_voted'  => $pvm_mv_date . ' ' . date( 'H:i:s' ),
                    ],
                    [ '%d', '%s', '%d', '%s', '%d', '%s' ]
				);

				$pvm_mv_vote_type = 2; // for dislike

				$wpdb->insert(
					$summary_table,
					[
						'postid'      => $post_id,
						'post_type'   => $post_type,
						'vote_type'   => $pvm_mv_vote_type, // like=1, dislike=2
						'vote_date'   => $pvm_mv_date,
						'total_votes' => $pvm_manual_votes, // default is 1.
						'last_voted'  => $pvm_mv_date . ' ' . date( 'H:i:s' ),
					],
					[ '%d', '%s', '%d', '%s', '%d', '%s' ]
				);
			}
		}
	}

	/**
     * Delete the post vote count data.
     * Delete Voting Data When delete a post.
     *
     * @param int $post_id The post ID.
     */
	public function delete_data( $post_id ) {

		$post_id = isset( $_GET['post'] ) ? $_GET['post'] : '';

		if ( empty( $post_id ) ) {
			return '';
		}

		$post_type = get_post_type( $post_id );

		global $wpdb;

		$bpvm_voting_data_table    = $wpdb->prefix . 'bpvm_data'; // for deatils. each day info.
		$bpvm_voting_summary_table = $wpdb->prefix . 'bpvm_summary'; // daily summary.

		// Remove Data From Post Meta.
		delete_post_meta( $post_id, 'pvm_submission_counter' );
		delete_post_meta( $post_id, 'vote_date' );
		delete_post_meta( $post_id, 'pvm_voted_ip' );
		delete_post_meta( $post_id, 'pvm_like_votes_count' );
		delete_post_meta( $post_id, 'pvm_dislike_votes_count' );
		delete_post_meta( $post_id, 'pvm_liked_votes_by_date' );
		delete_post_meta( $post_id, 'pvm_disliked_votes_by_date' );

		// Remove Data From Data Table.

		$wpdb->delete(
            $bpvm_voting_data_table,
            [ 'postid' => $post_id, 'post_type' => $post_type ],
            [ '%d', '%s' ] // Where Format
		);

		wp_reset_postdata();

		// Remove Data From Summary Table.

		$wpdb->delete(
            $bpvm_voting_summary_table,
            [ 'postid' => $post_id, 'post_type' => $post_type ],
            [ '%d', '%s' ] // Where Format
		);

		wp_reset_postdata();
	}
}
