<?php
namespace BPVMWP\Base;

use Xenioushk\BwlPluginApi\Api\PluginUpdate\WpAutoUpdater;

/**
 * Class for plugin update.
 *
 * @since: 1.1.0
 * @package BPVM
 */
class PluginUpdate {

  	/**
     * Register the plugin text domain.
     */
	public function register() {
		add_action( 'admin_init', [ $this, 'check_for_the_update' ] );
	}

	/**
     * Check for the plugin update.
     */
	public function check_for_the_update() {

		$base          = 'https://projects.bluewindlab.net/wpplugin/zipped/plugins/';
		$notifier_file = $base . 'bpvm/notifier_bpvm.php';
		new WpAutoUpdater( BPVM_PLUGIN_VERSION, $notifier_file, BPVM_UPDATER_SLUG );
	}
}
