<?php
namespace BPVMWP\Base;

use BPVMWP\Helpers\PluginColorScheme;
use BPVMWP\Helpers\PluginConstants;

/**
 * Class FrontendInlineStyles
 *
 * This class handles the inline styles for the plugin.
 *
 * @package BPVMWP
 */
class FrontendInlineStyles {

	/**
	 * Plugin options.
	 *
	 * @var array
	 */
	private $options;

    /**
     * Plugin color scheme.
     *
     * @var array
     */
    private $color_scheme;

	/**
	 * FrontendInlineStyles constructor.
	 */
	public function __construct() {
		$this->options      = PluginConstants::$plugin_options;
        $this->color_scheme = PluginColorScheme::$color_scheme;
	}

	/**
	 * Register
	 */
	public function register() {
		add_action( 'wp_head', [ $this, 'get_inline_styles' ] );
	}

	/**
	 * Get the styles.
	 */
	public function get_inline_styles() {

        $options = $this->options;

        extract( $this->color_scheme ); //phpcs:ignore

        $custom_theme = '';

        // Like Thumb Color.
        $custom_theme .= $this->get_btn_styles( 'like' );

        // Like bar.
        $custom_theme .= sprintf( '.bg-green{ background-color:%s !important;}', $options['pvm_like_bar_color'] ?? $like_bar_color );

        $disable_down_vote_status = $options['pvm_disable_down_vote_status'] ?? 0;

        if ( ! $disable_down_vote_status ) {

            // Dislike Thumb Color.
            $custom_theme .= $this->get_btn_styles( 'dislike' );

            // Dislike bar.
            $custom_theme .= sprintf( '.bg-red{ background-color:%s !important;}', $options['pvm_dislike_bar_color'] ?? $dislike_bar_color );

        }

        // Tipsy status.
        $tipsy_status = intval( $options['pvm_tipsy_status'] ?? 1 );

        // Tipsy background and text color.
        if ( $tipsy_status ) {
			$custom_theme .= sprintf( '.tipsy-inner{ background: %s; color: %s;}',
                $options['pvm_tipsy_bg'] ?? $tipsy_bg,
			$options['pvm_tipsy_text_color'] ?? $tipsy_text_color );
		}
        // Custom CSS
        $custom_theme .= $options['pvm_custom_css'] ?? '';

        printf( '<style type="text/css" id="bpvm-inline-custom-styles">%s', $custom_theme ); // phpcs:ignore

	}

    /**
     * Get the button styles.
     *
     * @param string $btn_type The button type (like or dislike).
     *
     * @return string
     */
	private function get_btn_styles( $btn_type = 'like' ) {

		$options = $this->options;

		extract( $this->color_scheme ); //phpcs:ignore

		switch ( $btn_type ) {
			case 'like':
				$like_thumb_color          = $options['pvm_like_thumb_color'] ?? $like_thumb_color;
				$like_thumb_bg_color       = $options['pvm_like_thumb_bg_color'] ?? $like_thumb_bg_color;
				$like_thumb_hover_color    = $options['pvm_like_thumb_hover_color'] ?? $like_thumb_hover_color;
				$like_thumb_hover_bg_color = $options['pvm_like_thumb_hover_bg_color'] ?? $like_thumb_hover_bg_color;

				$custom_theme  = '.pvm_btn_container .btn_like{ color: ' . $like_thumb_color . ' !important; background-color: ' . $like_thumb_bg_color . ' !important;}';
				$custom_theme .= '.pvm_btn_container .btn_like:hover{ background-color: ' . $like_thumb_hover_bg_color . ' !important;}';
				$custom_theme .= '.pvm_btn_container .icon_like_color, .bpvm-widget .icon_like_color{ color: ' . $like_thumb_color . ' !important;}';
				$custom_theme .= '.pvm_btn_container .btn_like:hover .icon_like_color{ color: ' . $like_thumb_hover_color . ' !important;}';

				return $custom_theme;

			case 'dislike':
				$dislike_thumb_color          = $options['pvm_dislike_thumb_color'] ?? $dislike_thumb_color;
				$dislike_thumb_bg_color       = $options['pvm_dislike_thumb_bg_color'] ?? $dislike_thumb_bg_color;
				$dislike_thumb_hover_color    = $options['pvm_dislike_thumb_hover_color'] ?? $dislike_thumb_hover_color;
				$dislike_thumb_hover_bg_color = $options['pvm_dislike_thumb_hover_bg_color'] ?? $dislike_thumb_hover_bg_color;

				$custom_theme  = '.pvm_btn_container .btn_dislike{ color: ' . $dislike_thumb_color . ' !important; background-color: ' . $dislike_thumb_bg_color . ' !important;}';
				$custom_theme .= '.pvm_btn_container .btn_dislike:hover{ background-color: ' . $dislike_thumb_hover_bg_color . ' !important;}';
				$custom_theme .= '.pvm_btn_container .icon_dislike_color, .bpvm-widget .icon_dislike_color{ color: ' . $dislike_thumb_color . '  !important;}';
				$custom_theme .= '.pvm_btn_container .btn_dislike:hover .icon_dislike_color{ color: ' . $dislike_thumb_hover_color . ' !important;}';

				return $custom_theme;

			default:
				return '';
		}
	}
}
