<?php
namespace BPVMWP\Base;

use BPVMWP\Helpers\PluginConstants;

/**
 * Class FrontendInlineScripts
 *
 * This class handles the inline scripts for the plugin.
 *
 * @package BPVMWP
 */
class FrontendInlineScripts {

	/**
	 * Plugin options.
	 *
	 * @var array
	 */
	public $options;

	/**
	 * FrontendInlineScripts constructor.
	 */
	public function __construct() {
		$this->options = PluginConstants::$plugin_options;
	}

	/**
	 * Register
	 */
	public function register() {
		add_action( 'wp_head', [ $this, 'get_inline_scripts' ] );
	}

	/**
	 * Set the scripts.
	 */
	public function get_inline_scripts() {

		$data = $this->options;

		?>
<script type="text/javascript" id="bpvm-inline-custom-scripts">
var ajaxurl = '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>',
  err_feedback_msg = '<?php esc_html_e( ' Please Write Your Feedback Message', 'bwl-pro-voting-manager' ); ?>',
  pvm_feedback_thanks_msg = '<?php esc_html_e( 'Thanks for your feedback!', 'bwl-pro-voting-manager' ); ?>',
  pvm_unable_feedback_msg =
  '<?php esc_html_e( 'Unable to receive your feedback. Please try again !', 'bwl-pro-voting-manager' ); ?>',
  err_pvm_captcha = '<?php esc_html_e( ' Incorrect Captcha Value!', 'bwl-pro-voting-manager' ); ?>',
  pvm_wait_msg = '<?php esc_html_e( 'Please Wait .....', 'bwl-pro-voting-manager' ); ?>',
  pvm_tipsy_status = '<?php echo $data['pvm_tipsy_status'] ?? 1; ?>',
  pvm_disable_feedback_status = '<?php echo $data['pvm_disable_feedback_status'] ?? 0; ?>';
</script>

<?php

	}
}
