<?php
namespace BPVMWP\Base;

use Xenioushk\BwlPluginApi\Api\Filters\FiltersApi;
use BPVMWP\Callbacks\Filters\Frontend\VotingInterfaceCb;

/**
 * Class for frontend filter handlers.
 *
 * @package BPVMWP
 */
class FrontendFilterHandlers {

	/**
	 * Register frontend filters.
	 */
	public function register() {

		// Initialize FiltersApi.
		$filters_api = new FiltersApi();

		// Initalize Callbacks.
		$voting_interface_cb = new VotingInterfaceCb();

		// Filters.
		// @example: tag, callback, priority, arg
		$filters = [
			[
				'tag'      => 'the_content',
				'callback' => [ $voting_interface_cb, 'get_the_layout' ],
			],
		];

		if ( ! empty( $filters ) ) {
			$filters_api->add_filters( $filters )->register();
		}
	}
}
