<?php

namespace BPVMWP\Base;

use Xenioushk\BwlPluginApi\Api\AjaxHandlers\AjaxHandlersApi;
use BPVMWP\Callbacks\FrontendAjaxHandlers\CountVotesCb;
use BPVMWP\Callbacks\FrontendAjaxHandlers\DislikeFeedbackCb;

/**
 * Class for frontend ajax handlers.
 *
 * @package BPVMWP
 * @since: 1.1.0
 * @author: Mahbub Alam Khan
 */
class FrontendAjaxHandlers {

	/**
	 * Register frontend ajax handlers.
	 */
	public function register() {

		$ajax_handlers_api = new AjaxHandlersApi();

		// Initalize Callbacks.
		$count_votes_cb      = new CountVotesCb();
		$dislike_feedback_cb = new DislikeFeedbackCb();

		// Do not change the tag.
		// If do so, you need to change in js file too.
		$adminAjaxRequests = [

			[
				'tag'      => 'bwl_pvm_add_rating',
				'callback' => [ $count_votes_cb, 'add' ],
			],

			[
				'tag'      => 'bwl_pvm_save_post_data',
				'callback' => [ $dislike_feedback_cb, 'save' ],
			],

		];

		$ajax_handlers_api->add_ajax_handlers( $adminAjaxRequests )->register();
	}
}
