<?php
namespace BPVMWP\Base;

use BPVMWP\Helpers\PluginConstants;

/**
 * Class for registering the plugin scripts and styles.
 *
 * @package BPVMWP
 */
class Enqueue {

	/**
	 * Frontend script slug.
	 *
	 * @var string $frontend_script_slug
	 */
	private $frontend_script_slug;

	/**
	 * Constructor.
	 */
	public function __construct() {
		// Frontend script slug.
		// This is required to hook the loclization texts.
		$this->frontend_script_slug = 'bpvm-frontend';
	}

	/**
	 * Register the plugin scripts and styles loading actions.
	 */
	public function register() {
		add_action( 'wp_enqueue_scripts', [ $this, 'get_the_styles' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'get_the_scripts' ] );
	}

	/**
	 * Load the plugin styles.
	 */
	public function get_the_styles() {
		// Register Styles.
		$options = PluginConstants::$plugin_options;

		wp_enqueue_style(
            $this->frontend_script_slug,
            BPVM_STYLES_ASSETS_DIR . 'frontend.css',
            [],
            BPVM_PLUGIN_VERSION
		);

		if ( is_rtl() ) {

			wp_enqueue_style(
				'bpvm-frontend-rtl',
				BPVM_STYLES_ASSETS_DIR . 'frontend_rtl.css',
				[],
				BPVM_PLUGIN_VERSION
			);
		}

		if ( isset( $options['pvm_fontawesome_status'] ) && intval( $options['pvm_fontawesome_status'] ) === 1 ) {

			wp_enqueue_style(
                'font-awesome-5',
                BPVM_PLUGIN_LIBS_DIR . 'font-awesome/font-awesome.min.css',
                [],
                BPVM_PLUGIN_VERSION
			);

			wp_enqueue_style(
                'font-awesome-5-shims',
                BPVM_PLUGIN_LIBS_DIR . 'font-awesome/v4-shims.min.css',
                [],
                BPVM_PLUGIN_VERSION
			);
		}
	}

	/**
	 * Load the plugin scripts.
	 */
	public function get_the_scripts() {

						wp_enqueue_script(
							'jquery-tipsy',
							BPVM_PLUGIN_LIBS_DIR . 'jquery.tipsy/scripts/jquery.tipsy.js',
							[ 'jquery' ],
							BPVM_PLUGIN_VERSION,
							true
						);

            wp_enqueue_script(
                $this->frontend_script_slug,
                BPVM_SCRIPTS_ASSETS_DIR . 'frontend.js',
                [ 'jquery' ],
                BPVM_PLUGIN_VERSION,
                true
            );

		// Load frontend variables used by the JS files.
		$this->get_the_localization_texts();
	}

	/**
	 * Load the localization texts.
	 */
	private function get_the_localization_texts() {

		// Localize scripts.
		// Frontend.
		// Access data: bpvmFrontendData.version
		wp_localize_script(
            $this->frontend_script_slug,
            'bpvmFrontendData',
            [
				'title'               => BPVM_PLUGIN_TITLE,
				'version'             => BPVM_PLUGIN_VERSION,
				'url'                 => BPVM_PRODUCT_URL,
				'ajaxurl'             => esc_url( admin_url( 'admin-ajax.php' ) ),
				'bpvm_frontend_nonce' => wp_create_nonce( BPVM_FRONTEND_NONCE_ID ),
				'pvm_wait_msg'        => esc_html__( 'Please Wait .....', 'bwl-pro-voting-manager' ),
            ]
		);
	}
}
