<?php

/**
 * @package BwlKbManager
 */

namespace BwlKbManager\Base;

use BwlKbManager\Api\FilterHandlersApi;
use BwlKbManager\Callbacks\FilterHandlers\Admin\MetaInfoCb;
use BwlKbManager\Callbacks\FilterHandlers\Admin\KbTaxnomyPostsFilterCb;

class PluginAdminFilterHandlers extends BaseController {


	public $filterSettings         = [];
	public $adminFilters           = [];
	public $adminAdditionalFilters = [];


	public $filterHandlersApi;

	// CB
	public $metaInfoCb;
	public $kbTaxnomyPostsFilterCb;

	public function register() {

		$this->filterHandlersApi = new FilterHandlersApi();

		// Frontend Filters.
		$this->setAdminFilters();
		$this->loadAdminFilters();

		// Additional Filters.

		$this->setAdditionalFilters();
		$this->loadAdditionalFilters();
		// return 1;
	}



	public function setAdminFilters() {

		// Initalize Callbacks.
		// priority,
		// arg
		$this->metaInfoCb = new MetaInfoCb();

		$filters = [
			[
				'tag'      => 'plugin_row_meta',
				'callback' => [ $this->metaInfoCb, 'setMetaInfo' ],
				'priority' => 1,
				'arg'      => 2,
			],
		];

		$this->adminFilters = $filters;
	}

	public function loadAdminFilters() {

		// echo "<pre>";
		// print_r($this->adminAdditionalFilters);
		// echo "</pre>";

		// create loop and assign callback fucntions .

		if ( ! empty( $adminFilters = $this->adminFilters ) && is_admin() ) {
			$this->filterHandlersApi->addFilters( $adminFilters )->register();
		}
	}


	public function setAdditionalFilters() {

		// Initalize Callbacks.
		$this->kbTaxnomyPostsFilterCb = new KbTaxnomyPostsFilterCb();

		// priority,
		// arg

		$filters = [
			[
				'tag'      => 'parse_query',
				'callback' => [ $this->kbTaxnomyPostsFilterCb, 'filterTaxonomyPosts' ],
			],
		];

		$this->adminAdditionalFilters = $filters;
	}

	public function loadAdditionalFilters() {
		if ( ! empty( $adminAdditionalFilters = $this->adminAdditionalFilters ) ) {
			$this->filterHandlersApi->addFilters( $adminAdditionalFilters )->register();
		}
	}
}
