<?php
namespace BPVMWP\Base;

/**
 * Class for registering the plugin admin scripts and styles.
 *
 * @package BPVMWP
 */
class AdminEnqueue {

	/**
	 * Admin script slug.
	 *
	 * @var string $admin_script_slug
	 */
	private $admin_script_slug;

	/**
	 * Constructor.
	 */
	public function __construct() {
		// Frontend script slug.
		// This is required to hook the loclization texts.
		$this->admin_script_slug = 'bpvm-admin';
	}

	/**
	 * Register the plugin scripts and styles loading actions.
	 */
	public function register() {
		// for admin.
		add_action( 'admin_enqueue_scripts', [ $this, 'get_the_scripts' ] );
	}
	/**
     * Load the plugin styles and scripts.
     */
	public function get_the_scripts() {

		wp_enqueue_style(
            'bpvm-jquery-ui',
            BPVM_PLUGIN_LIBS_DIR . 'jqueryui//jquery-ui.min.css',
            [],
            BPVM_PLUGIN_VERSION
		);

		wp_enqueue_style(
			'bpvm-shortcode-editor',
			BPVM_PLUGIN_LIBS_DIR . 'tinymce/styles/bwl_pvm_editor.css',
			[],
			BPVM_PLUGIN_VERSION
		);

		wp_enqueue_style(
			'bpvm-multiple-select',
			BPVM_PLUGIN_LIBS_DIR . 'multiple-select/styles/multiple-select.css',
			[],
			BPVM_PLUGIN_VERSION
		);

		wp_enqueue_style(
			'bpvm-datatables',
			BPVM_PLUGIN_LIBS_DIR . 'jquery.dataTables/styles/jquery.dataTables.css',
			[],
			BPVM_PLUGIN_VERSION
		);

		wp_enqueue_style(
			$this->admin_script_slug,
			BPVM_STYLES_ASSETS_DIR . 'admin.css',
			[],
			BPVM_PLUGIN_VERSION
		);

		// Load admin scripts.

		// Enqueue jQuery UI components
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-dialog' );

		wp_register_script(
			'bpvm-chart-js',
			BPVM_PLUGIN_LIBS_DIR . 'chart-js/scripts/chart.js',
			[],
			BPVM_PLUGIN_VERSION,
			true
		);

		wp_enqueue_script(
			'bpvm-datatable',
			BPVM_PLUGIN_LIBS_DIR . 'jquery.dataTables/scripts/jquery.dataTables.min.js',
			[
				'jquery',
			],
			BPVM_PLUGIN_VERSION,
			true
		);

		wp_enqueue_script(
			'bpvm-multiple-select',
			BPVM_PLUGIN_LIBS_DIR . 'multiple-select/scripts/jquery.multiple.select.js',
			[
				'jquery',
			],
			BPVM_PLUGIN_VERSION,
			true
		);

		wp_enqueue_script(
            $this->admin_script_slug,
            BPVM_SCRIPTS_ASSETS_DIR . 'admin.js',
            [
				'jquery',
			],
            BPVM_PLUGIN_VERSION,
            true
        );
		// Load frontend variables used by the JS files.
		$this->get_the_localization_texts();
	}

	/**
	 * Load the localization texts.
	 */
	private function get_the_localization_texts() {

		// Localize scripts.
		// Frontend.
		// Access data: bpvmAdminData.version
		wp_localize_script(
            $this->admin_script_slug,
            'bpvmAdminData',
            [
				'ajaxurl'                 => esc_url( admin_url( 'admin-ajax.php' ) ),
				'nonce'                   => wp_create_nonce( BPVM_ADMIN_NONCE_ID ),
				'bpvm_text_loading'       => esc_html__( 'Loading .....', 'bwl-pro-voting-manager' ),
				'bpvm_no_feedback_msg'    => esc_html__( 'No Feedback Message Found!', 'bwl-pro-voting-manager' ),
				'bpvm_confirm_remove_msg' => esc_html__( 'Are you sure to remove data?', 'bwl-pro-voting-manager' ),
				'product_id'              => BPVM_PRODUCT_ID,
				'installation'            => get_option( BPVM_PRODUCT_INSTALLATION_TAG ),
				'bpvm_dir'                => BPVM_PLUGIN_URL, // for tinymce editor.
				'bpvm_libs_dir'           => BPVM_PLUGIN_LIBS_DIR, // for library assets
			]
		);
	}
}
