<?php
namespace BPVMWP\Base;

use BPVMWP\Callbacks\AdminAjaxHandlers\TinyMceAjaxCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\BulkEditSaveCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\UserFeedbackCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\Report\VoteDataCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\Report\DeleteVoteCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\Report\UpdateVoteCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\PluginInstallationCb;
use Xenioushk\BwlPluginApi\Api\AjaxHandlers\AjaxHandlersApi;
use BPVMWP\Callbacks\AdminAjaxHandlers\Report\PostTypeDataCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\Report\SinglePostDataCb;
use BPVMWP\Callbacks\AdminAjaxHandlers\Report\RefreshVotingDataCb;
/**
 * Class for admin ajax handlers.
 *
 * @package BPVMWP
 */
class AdminAjaxHandlers {

	/**
	 * Register admin ajax handlers.
	 */
	public function register() {

		$ajax_handlers_api      = new AjaxHandlersApi();
		$plugin_installation_cb = new PluginInstallationCb();
		$delete_vote_cb         = new DeleteVoteCb();
		$single_post_data_cb    = new SinglePostDataCb();
		$tiny_mce_ajax_cb       = new TinyMceAjaxCb();
		$bulk_edit_save_cb      = new BulkEditSaveCb();

		// Do not change the tag.
		// If do so, you need to change in js file too.
		$adminAjaxRequests = [
			[
				'tag'      => 'bpvm_get_posts_data',
				'callback' => [ ( new PostTypeDataCb() ), 'get_data' ],
			],
			[
				'tag'      => 'pvm_voting_stats',
				'callback' => [ ( new VoteDataCb() ), 'get_data' ],
			],
			[
				'tag'      => 'bpvm_update_vote_data',
				'callback' => [ ( new UpdateVoteCb() ), 'update' ],
			],
			[
				'tag'      => 'bpvm_delete_vote_data',
				'callback' => [ $delete_vote_cb, 'delete' ],
			],
			[
				'tag'      => 'bpvm_get_single_post_data',
				'callback' => [ $single_post_data_cb, 'get_data' ],
			],
			[
				'tag'      => 'bpvm_refresh_voting_data',
				'callback' => [ ( new RefreshVotingDataCb() ), 'refresh_data' ],
			],
			[
				'tag'      => 'bpvm_installation_counter',
				'callback' => [ $plugin_installation_cb, 'save' ],
			],
			[
				'tag'      => 'bwl_pvm_sc_content',
				'callback' => [ $tiny_mce_ajax_cb, 'get_the_editor' ],
			],
			[
				'tag'      => 'manage_wp_posts_using_bulk_edit_pvm',
				'callback' => [ $bulk_edit_save_cb, 'save_data' ],
			],
			[
				'tag'      => 'pvm_remove_feedback_data',
				'callback' => [ ( new UserFeedbackCb() ), 'remove' ],
			],

		];

		$ajax_handlers_api->add_ajax_handlers( $adminAjaxRequests )->register();
	}
}
