<?php
namespace BPVMWP\Base;

use Xenioushk\BwlPluginApi\Api\Actions\ActionsApi;
use BPVMWP\Callbacks\ActionHandlers\Admin\TinyMceCb;
use BPVMWP\Callbacks\ActionHandlers\Admin\ManageVoteCountCb;

/**
 * Class for plugin admin action handlers.
 *
 * @package BPVMWP
 */
class AdminActionHandlers {
	// add_image_size( 'pvm-post-thumb', 32, 32, true );

	/**
	 * Register admin actions.
	 */
	public function register() {

		$actions_api = new ActionsApi();

		// Initalize Callbacks.
		$manage_vote_count_cb = new ManageVoteCountCb();
		$tiny_mce_cb          = new TinyMceCb();

		// priority,
		// arg

		$actions = [
			[
				'tag'      => 'save_post',
				'callback' => [ $manage_vote_count_cb, 'save_date' ],
			],
			[
				'tag'      => 'delete_post',
				'callback' => [ $manage_vote_count_cb, 'delete_data' ],
			],
			[
				'tag'      => 'admin_init',
				'callback' => [ $tiny_mce_cb, 'init_tiny_mce_button' ],
			],
		];

		if ( ! empty( $actions ) ) {
			$actions_api->add_actions( $actions )->register();
		}

	}
}
