<?php
namespace BPVMWP\Base;

/**
 * Class ActivationRedirect
 *
 * After plugin activation, it will redirect the user to about plugin page
 *
 * @package BPVMWP
 */
class ActivationRedirect {

	/**
	 * URL to redirect after plugin activation
	 *
	 * @var string
	 */
	private $redirect_url;

	/**
	 * Constructor method
	 *
	 * @since 1.4.6
	 */
	public function __construct() {

		$this->redirect_url = 'admin.php?page=bwl-pvm';
	}

	/**
	 * Register the actions/hooks
	 *
	 * @since 1.4.6
	 */
	public function register() {
		add_action( 'admin_init', [ $this, 'get_the_page' ] );
	}

	/**
	 * Callback function for the about plugin page.
	 *
	 * @since 1.4.6
	 */
	public function get_the_page() {

		if ( get_transient( 'bpvm_activation_redirect' ) ) {

			delete_transient( 'bpvm_activation_redirect' );

			if ( is_admin() && ! isset( $_GET['activate-multi'] ) ) {
				wp_safe_redirect( admin_url( $this->redirect_url ) );
				exit;
			}
		}
	}
}
