<?php
namespace BPVMWP\Base;

use BPVMWP\Controllers\Database\Tables;

/**
 * Class Active
 *
 * After plugin activation, it flush the rewrite rules.
 * Also, set the transient value for activation redirect page.
 *
 * @package BPVMWP
 */
class Activate {

	/**
	 *  Instance of the WPDB.
	 *
	 * @var object $wpdb
	 */
	private $wpdb;

	/**
	 * Constructor for the class.
	 *
	 * @param object $wpdb  Instance of the WPDB.
	 */
	public function __construct( $wpdb ) {
		$this->wpdb = $wpdb;
	}

	/**
	 * Callback function for the about plugin page.
	 *
	 * @since 2.0.6
	 */
	public function activate() {
		flush_rewrite_rules();
		set_transient( 'bpvm_activation_redirect', true, 5 );
	}

	/**
	 * Create database tables.
	 */
	public function create_db_tables() {
		$tables = new Tables( $this->wpdb );
		$tables->register();
	}
}
