<?php

/**
 * @package BwlKbManager
 */

namespace BwlKbManager\Base;

use BwlKbManager\Base\Helpers;
use BwlKbManager\Api\ActionHandlersApi;
use BwlKbManager\Callbacks\ActionHandlers\KbStickyButtonsCb;
use BwlKbManager\Callbacks\ActionHandlers\KbFrontendCommonCb;
use BwlKbManager\Callbacks\ActionHandlers\KbTaxonomyPageTitleCb;

class ActionHandlers extends BaseController {


	public $actionSettings = [];

	public $pluginFrontendActions = [];


	public $actionHandlersApi;

	// Callbacks
	public $kbStickyButtonsCb;
	public $kbFrontendCommonCb;
	public $kbTaxonomyPageTitleCb;

	public function register() {

		$this->actionHandlersApi = new ActionHandlersApi();

		// Frontend actions.
		$this->setPluginFrontendActions();
		$this->loadPluginFrontendActions();
	}

	public function setPluginFrontendActions() {

		// Initalize Callbacks.
		// priority,
		// arg

		// Initalize Callbacks.
		$this->kbStickyButtonsCb     = new KbStickyButtonsCb();
		$this->kbFrontendCommonCb    = new KbFrontendCommonCb();
		$this->kbTaxonomyPageTitleCb = new KbTaxonomyPageTitleCb();

		$actions = [
			[
				'tag'      => 'the_content',
				'callback' => [ $this->kbFrontendCommonCb, 'cleanUpPluginShortcodes' ],
				'priority' => 100,
			],
			[
				'tag'      => 'wp_head',
				'callback' => [ $this->kbFrontendCommonCb, 'setPluginJsData' ],
				'priority' => 100,
			],
			[
				'tag'      => 'wp_title',
				'callback' => [ $this->kbTaxonomyPageTitleCb, 'setCustomCatPageTitle' ],
				'priority' => 10,
				'arg'      => 1,
			],
			[
				'tag'      => 'wp_title',
				'callback' => [ $this->kbTaxonomyPageTitleCb, 'setCustomTagPageTitle' ],
				'priority' => 10,
				'arg'      => 1,
			],

			[
				'tag'      => 'wp_footer',
				'callback' => [ $this->kbStickyButtonsCb, 'getStickyButtons' ],
			],
		];

		$this->pluginFrontendActions = $actions;
	}

	public function loadPluginFrontendActions() {

		// echo "<pre>";
		// print_r($this->wp_additional_actions);
		// echo "</pre>";

		// create loop and assign callback fucntions .

		if ( ! empty( $pluginFrontendActions = $this->pluginFrontendActions ) ) {
			$this->actionHandlersApi->addactions( $pluginFrontendActions )->register();
		}
	}
}
