<?php

/**
 * Plugin Name: BWL Pro Voting Manager
 * Plugin URI: https://1.envato.market/bpvm-wp
 * Description: The plugin offers a convenient feature to integrate a custom voting system into any posts automatically.
 * Author: BlueWindLab
 * Version: 1.4.9
 * Author URI: https://bluewindlab.net
 * WP Requires at least: 6.0+
 * Text Domain: bwl-pro-voting-manager
 * Domain Path: /lang/
 *
 * @package   BPVMWP
 * @author    Mahbub Alam Khan
 * @license   GPL-2.0+
 * @link      https://codecanyon.net/user/xenioushk
 * @copyright 2025 BlueWindLab
 */

namespace BPVMWP;

defined( 'ABSPATH' ) || die( 'Unauthorized access' );

if ( file_exists( __DIR__ . '/vendor/autoload.php' ) ) {
	require_once __DIR__ . '/vendor/autoload.php';
}

// Load the Action Scheduler library if it is not already loaded
if ( ! class_exists( 'ActionScheduler' ) && file_exists( __DIR__ . '/vendor/woocommerce/action-scheduler/action-scheduler.php' ) ) {
	require_once __DIR__ . '/vendor/woocommerce/action-scheduler/action-scheduler.php';
}

use BPVMWP\Base\Activate;
use BPVMWP\Base\Deactivate;

/**
 * Function to handle the activation of the plugin.
 *
 * @return void
 */
function activate_plugin() { // phpcs:ignore
	global $wpdb;
	$activate = new Activate( $wpdb );
	$activate->activate();
	$activate->create_db_tables();
}

	/**
	 * Function to handle the deactivation of the plugin.
	 *
	 * @return void
	 */
	function deactivate_plugin() { // phpcs:ignore
	Deactivate::deactivate();
}

	register_activation_hook( __FILE__, __NAMESPACE__ . '\\activate_plugin' );
	register_deactivation_hook( __FILE__, __NAMESPACE__ . '\\deactivate_plugin' );

/**
 * Function to handle the initialization of the plugin.
 *
 * @return void
 */
function init_bpvmwp() {

	if ( class_exists( 'BPVMWP\\Init' ) ) {
            Init::register_services();
	}
}

add_action( 'init', __NAMESPACE__ . '\\init_bpvmwp' );

require_once __DIR__ . '/includes/Widgets/index.php';
