<?php

/**
* @Description: Shortcode Editor Button
* @Created At: 08-04-2013
* @Last Edited AT: 26-06-2013
* @Created By: Mahbub
**/

add_action('admin_init', 'bpvm_tinymce_shortcode_button');

function bpvm_tinymce_shortcode_button() {
    
    if ( current_user_can('edit_posts') && current_user_can('edit_pages') && get_user_option( 'rich_editing' ) == 'true') {
        add_filter('mce_external_plugins', 'add_bpvm_shortcode_plugin');
        add_filter('mce_buttons', 'register_bpvm_shortcode_button');
    }
}

function register_bpvm_shortcode_button( $buttons ) {
    array_push($buttons, "bwl_pvm");
    return $buttons;
}

function add_bpvm_shortcode_plugin( $plugin_array ) {
    $plugin_array['bwl_pvm'] = plugins_url( BWL_PVM_PLUGIN_ROOT . '/tinymce/bpvm_tinymce_button.js');
    return $plugin_array;
}


// Shortcode Layout.

add_action('wp_ajax_bwl_pvm_sc_content', 'bwl_pvm_sc_content');
add_action( 'wp_ajax_nopriv_bwl_pvm_sc_content', 'bwl_pvm_sc_content' );

function bwl_pvm_sc_content() {
    
    ?>

    <h3>
        <?php esc_html_e('BPVM Shortcode Editor', 'bwl-pro-voting-manager'); ?>
        <span class="btn_pvm_editor_close">X</span>
    </h3>

    <div class="row">

        <label for="custom_selection"><?php esc_html_e('Selection Type', 'bwl-pro-voting-manager'); ?></label>

        <input type="radio" name="custom_selection" class="custom_selection" value="1" checked="checked"/>Voting Panel&nbsp;
        <input type="radio" name="custom_selection" class="custom_selection" value="2"/>Custom Filter

    </div>

    <hr class="bpvm-shortcode-seperator"/>

    <div class="row post_type_container">
        <label for="bpvm_post_type"><?php esc_html_e('Post Type', 'bwl-pro-voting-manager'); ?></label>
        <select id="bpvm_post_type" name="bpvm_post_type">
            <option value="" selected>- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
            <?php
            $available_bpvm_post_types = bpvm_get_widget_custom_post_types();

            foreach ($available_bpvm_post_types as $bpvm_post_type_key => $bpvm_post_type_value) :

                $bpvm_post_type_value = strtolower($bpvm_post_type_value);

                $bpvm_post_type_title = ucfirst(str_replace('_', ' ', $bpvm_post_type_value));
                ?>
                <option value="<?php echo $bpvm_post_type_value; ?>"><?php echo $bpvm_post_type_title; ?></option>
                <?php
            endforeach;
            ?>
            <option value="post-format-gallery"><?php esc_html_e('Gallery posts', 'bwl-pro-voting-manager'); ?></option>
        </select>
    </div>

    <div class="row thumbnail_container">

        <label for="bpvm_thumbnail_filter"><?php esc_html_e('Display Thumbnail', 'bwl-pro-voting-manager') ?></label>
        <input type="checkbox" id="bpvm_thumbnail_filter" name="bpvm_thumbnail_filter" value="1" class="bpvm_checkbox"/>

    </div> <!-- end row  -->

    <div class="row date_filter_container">

        <label for="bpvm_date_filter"><?php esc_html_e('Day Filter', 'bwl-pro-voting-manager') ?></label>
        <input type="checkbox" id="bpvm_date_filter" name="bpvm_date_filter" value="1" class="bpvm_checkbox" checked="checked"/>

    </div> <!-- end row  -->


    <div class="row interval_container">
        <label for="bpvm_interval"><?php esc_html_e('Date Interval', 'bwl-pro-voting-manager'); ?></label>
        <select id="bpvm_interval" name="bpvm_interval">
            <option value="" selected>- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
            <option value="1 day"><?php esc_html_e('1 Day', 'bwl-pro-voting-manager'); ?></option>
            <option value="1 week" selected="selected"><?php esc_html_e('1 Week', 'bwl-pro-voting-manager'); ?> ( <?php esc_html_e('Default', 'bwl-pro-voting-manager'); ?> )</option>
            <option value="1 month"><?php esc_html_e('1 Month', 'bwl-pro-voting-manager'); ?></option>
            <option value="custom"><?php esc_html_e('Custom', 'bwl-pro-voting-manager'); ?></option>
        </select>
    </div>

    <div class="row custom_interval_container bpvm_dn">
        <label for="custom_interval_container"><?php esc_html_e('Custom Date Range', 'bwl-pro-voting-manager'); ?></label>
        <input type="text" id="bpvm_interval_start" name="bpvm_interval_start" value="" size="3" style="width: 125px;" placeholder="Start(Y-M-D)"/> - 
        <input type="text" id="bpvm_interval_end" name="bpvm_interval_end" value="" size="3" style="width: 125px;" placeholder="End(Y-M-D)"/> 
    </div>

    <div class="row limit_container">
        <label for="bpvm_limit"><?php esc_html_e('Post Display Limit', 'bwl-pro-voting-manager'); ?></label>
        <input type="text" id="bpvm_limit" name="bpvm_limit" value="" size="3" style="width: 100px;"/> <small>i.e: Set value 5 for display 5 posts.</small>
    </div>

    <div class="row orderby_container">
        <label for="bpvm_orderby"><?php esc_html_e('Order By', 'bwl-pro-voting-manager'); ?></label>
        <select id="bpvm_orderby" name="orderby">
            <option value="" selected>- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
            <option value="liked"><?php esc_html_e('Liked', 'bwl-pro-voting-manager'); ?></option>
            <option value="disliked"><?php esc_html_e('Disliked', 'bwl-pro-voting-manager'); ?></option>
        </select>
    </div>

    <div class="row order_container">
        <label for="bpvm_order"><?php esc_html_e('Order', 'bwl-pro-voting-manager'); ?></label>
        <select id="bpvm_order" name="bpvm_order">
            <option value="" selected>- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
            <option value="ASC"><?php esc_html_e('Ascending', 'bwl-pro-voting-manager'); ?></option>
            <option value="DESC"><?php esc_html_e('Descending', 'bwl-pro-voting-manager'); ?></option>
        </select>
    </div>

    <div class="row animation_container">

        <label for="bpvm_animation"><?php esc_html_e('Voting Bar Animation', 'bwl-pro-voting-manager') ?></label>
        <input type="checkbox" id="bpvm_animation" name="bpvm_animation" value="1" class="bpvm_checkbox" checked="checked"/>

    </div> <!-- end row  -->

    <?php
    $bpvm_voting_themes = array(
        'animated_red_theme' => esc_html__('Red Theme', 'bwl-pro-voting-manager'),
        'animated_blue_theme' => esc_html__('Blue Theme', 'bwl-pro-voting-manager'),
        'animated_green_theme' => esc_html__('Green Theme', 'bwl-pro-voting-manager'),
        'animated_orange_theme' => esc_html__('Orange Theme', 'bwl-pro-voting-manager'),
        'animated_pink_theme' => esc_html__('Pink Theme', 'bwl-pro-voting-manager'),
        'animated_yellow_theme' => esc_html__('Yellow Theme', 'bwl-pro-voting-manager'),
        'animated_yellow_green_theme' => esc_html__('Yellow Green Theme', 'bwl-pro-voting-manager'),
        'animated_brown_theme' => esc_html__('brown Theme', 'bwl-pro-voting-manager'),
        'animated_chocolate_theme' => esc_html__('Chocolate Theme', 'bwl-pro-voting-manager'),
        'animated_crimson_theme' => esc_html__('Crimson Theme', 'bwl-pro-voting-manager'),
    );
    ?>

    <div class="row like_theme_container">
        <label for="bpvm_like_theme"><?php esc_html_e('Like Bar Theme', 'bwl-pro-voting-manager'); ?></label>
        <select id="bpvm_like_theme" name="bpvm_like_theme">
            <option value="" selected>- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
            <?php foreach ($bpvm_voting_themes as $like_voting_theme_key => $like_voting_theme_value) : ?>
                <option value="<?php echo $like_voting_theme_key; ?>"><?php echo $like_voting_theme_value; ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="row dislike_theme_container">
        <label for="bpvm_dislike_theme"><?php esc_html_e('Dislike Bar Theme', 'bwl-pro-voting-manager'); ?></label>
        <select id="bpvm_dislike_theme" name="bpvm_dislike_theme">
            <option value="" selected>- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
            <?php foreach ($bpvm_voting_themes as $dislike_voting_theme_key => $dislike_voting_theme_value) : ?>
                <option value="<?php echo $dislike_voting_theme_key; ?>"><?php echo $dislike_voting_theme_value; ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div id="bwl_pvm_editor_popup_buttons">
        <input id="addShortCodebtn" name="addShortCodebtn" class="button-primary" type="button" value="Insert" />
        <input id="closeShortCodebtn" name="closeShortCodebtn" class="button" type="button" value="Close" />
    </div>


<?php    
    
    die();
    
}