<?php

add_shortcode('bwl_pvm', 'cb_bwl_pvm');

function cb_bwl_pvm($atts) {

    global $post;

    $post_id = get_the_ID();

    extract(shortcode_atts(array(
        'id' => $post_id,
        'status' => 1,
        'post_type' => get_post_type($post_id),
        'woo' => 0, // introduced in version 1.1.1  Provide support for WooCommerce page default woo is zero
        'animation' => 0,
        'like_theme' => '',
        'dislike_theme' => '',
        'dpc' => 0, // Display post content (For video post types)
        'voting_filter' => 0, // We display some custom elements here within a date range @introduced in version 1.1.0,
        'class' => ''
                    ), $atts));

    if (isset($id) && $id != "") {

        $post_id = $id;
        $post_type = get_post_type($post_id);
    }


    //@Description: Load Plugin Required Styles
    //@Since: Version 1.0.0

    wp_enqueue_script('bwl-pro-voting-manager-custom-script');


    /**
     * @Description: Parameter Definition
     * @Status: Display voting manager or not. 0. Hide 1. Show, 2. Voting Close. 
     * @Post Type: You can add custom post type to display voting manager any where of your blog.
     * @Post ID: Current Post, page, custom post ID.
     * */
    $output = bwl_pvm_shortcode_html($status, $post_type, $post_id, $animation, $like_theme, $dislike_theme, $dpc, $voting_filter, $woo, $class);

    return $output;
}

function bwl_pvm_shortcode_html($bwl_pvm_display_status, $post_type, $post_id, $animation, $like_theme, $dislike_theme, $dpc, $voting_filter, $woo, $class) {

//    echo "Voting Filter Status: " . $voting_filter;
    $content = "";
    $bpvm_unique_id = wp_rand();
    
    $class = ( isset($class) && $class!="" ) ? ' ' . $class .' ' : '';
    $bwl_pvm_container_class = 'bwl_pvm_container' . $class ; 
    
    


    if ($bwl_pvm_display_status != "" && $bwl_pvm_display_status == 0) {

        return $content;
        
    }

    if ($bwl_pvm_display_status != "" && $bwl_pvm_display_status == 2) {

        /*--- BUILD INTERFACE ---*/

        $pvm_interface = '<section class="'.$bwl_pvm_container_class.' pvm_clearfix">
                                        <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_html__('Voting Closed !', 'bwl-pro-voting-manager') . '</p>
                                     </section><!-- end .bwl_pvm_container -->';

        $content .= $pvm_interface;

        return $content;
    } else if ($bwl_pvm_display_status != "" && $bwl_pvm_display_status == 4) {

        /*--- BUILD INTERFACE---*/
        $bpvm_vote_start_date = get_post_meta($post_id, "bpvm_vote_start_date", true);
        $pvm_interface = '<section class="'.$bwl_pvm_container_class.' pvm_clearfix">
                                  <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_html__('Voting start date: ', 'bwl-pro-voting-manager') . ' ' . bpvm_change_date_format($bpvm_vote_start_date) . '</p>
                                 </section><!-- end .bwl_pvm_container -->';

        $content .= $pvm_interface;
        return $content;
    } else if ($bwl_pvm_display_status != "" && $bwl_pvm_display_status == 5) {


        /*--- BUILD INTERFACE---*/

        $pvm_interface = '<section class="'.$bwl_pvm_container_class.' pvm_clearfix">
                                  <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_html__('Voting date expired !', 'bwl-pro-voting-manager') . '</p>
                                 </section><!-- end .bwl_pvm_container -->';


        $content .= $pvm_interface;

        return $content;
    }

    // Display Voting Closed Message.

    $like_vote_counter = bpvm_get_vote_counts_meta($post_id);

    if ($like_vote_counter == "") {
        $like_vote_counter = 0;
    }

    $dislike_vote_counter = bpvm_get_vote_counts_meta($post_id, 2);

    if ($dislike_vote_counter == "") {
        $dislike_vote_counter = 0;
    }

    $pvm_feedback_message_unique_id = 'pvm_feedback_list_' . $post_id; // so idea is we are going to add post id after vairable name

    $prev_pvm_feedback_message = get_post_meta($post_id, $pvm_feedback_message_unique_id);

    $total_vote_counter = $like_vote_counter + $dislike_vote_counter;


    // Fixed in version 1.0.6

    if ($total_vote_counter != 0) {

        $like_percentage = ceil(pvm_calculate_percentage($total_vote_counter, $like_vote_counter));

        $dislike_percentage = 100 - $like_percentage;
    } else {

        $like_percentage = 0;

        $dislike_percentage = 0;
    }


    $pvm_data = get_option('bwl_pvm_options');
    
    $result_percentage = 0;

    if (isset($pvm_data['pvm_display_result_percentage']) && $pvm_data['pvm_display_result_percentage'] == 1) {
        $like_vote_counter = $like_percentage . '%';
        $dislike_vote_counter = $dislike_percentage . '%';
        $result_percentage = 1;
    }

    /*--- Feedback Title---*/

    if (isset($pvm_data ['pvm_feedback_form_title']) && $pvm_data ['pvm_feedback_form_title'] != "") {

        $pvm_feedback_form_title = sprintf(esc_html__('%s', 'bwl-pro-voting-manager'), $pvm_data ['pvm_feedback_form_title']);
    } else {

        $pvm_feedback_form_title = esc_html__("Tell us how can we improve this post?", 'bwl-pro-voting-manager');
    }

    /*--- Add Custom Icon For Like Button ---*/

    if (isset($pvm_data ['pvm_like_thumb_icon']) && $pvm_data ['pvm_like_thumb_icon'] != "") {

        $pvm_like_thumb_icon = $pvm_data ['pvm_like_thumb_icon'];

        $pvm_like_thumb_html = '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i>';
    } else {

        $pvm_like_thumb_icon = "fa-thumbs-o-up";

        $pvm_like_thumb_html = '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i>';
    }

    /*--- Add Custom Icon For Dislike Button ---*/

    if (isset($pvm_data ['pvm_dislike_thumb_icon']) && $pvm_data ['pvm_dislike_thumb_icon'] != "") {

        $pvm_dislike_thumb_icon = $pvm_data ['pvm_dislike_thumb_icon'];

        $pvm_dislike_thumb_html = '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i>';
    } else {

        $pvm_dislike_thumb_icon = "fa-thumbs-o-down";

        $pvm_dislike_thumb_html = '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i>';
    }


    /*--- Add Custom Icon For Dislike Button ---*/

    $pvm_disable_voting_bar_status = 0;

    if (isset($pvm_data['pvm_disable_voting_bar_status']) && $pvm_data['pvm_disable_voting_bar_status'] == 1) {

        $pvm_disable_voting_bar_status = 1;
    }



    /*--- Custom Image For Like Button---*/

    if (isset($pvm_data ['pvm_like_conditinal_fields']['enabled']) && $pvm_data['pvm_like_conditinal_fields']['enabled'] == 'on') {

        $pvm_custom_like_icon = $pvm_data['pvm_like_conditinal_fields']['pvm_custom_like_icon'];

        if (isset($pvm_custom_like_icon ['src']) && $pvm_custom_like_icon['src'] != "") {

            $pvm_like_thumb_html = '<img src="' . $pvm_custom_like_icon['src'] . '" class="pvm-custom-icon"/>';
        }
    }


    /*--- Custom Image For Dislike Button---*/

    if (isset($pvm_data ['pvm_dislike_conditinal_fields']['enabled']) && $pvm_data['pvm_dislike_conditinal_fields']['enabled'] == 'on') {

        $pvm_custom_dislike_icon = $pvm_data['pvm_dislike_conditinal_fields']['pvm_custom_dislike_icon'];

        if (isset($pvm_custom_dislike_icon ['src']) && $pvm_custom_dislike_icon['src'] != "") {

            $pvm_dislike_thumb_html = '<img src="' . $pvm_custom_dislike_icon['src'] . '" class="pvm-custom-icon"/>';
        }
    }


    /*--- Down Vote Status---*/

    $pvm_disable_down_vote_status = 0;

    if (isset($pvm_data['pvm_disable_down_vote_status']) && $pvm_data['pvm_disable_down_vote_status'] == 1) {

        $pvm_disable_down_vote_status = 1;
    }

    /*--- ADD VOTE STATUS---*/

    $vote_given_status = 0;

    $pvm_tipsy_like_title = "Like The Post";

    // Like Bar Color.

    if (isset($pvm_data['pvm_tipsy_like_title']) && $pvm_data['pvm_tipsy_like_title'] != "") {

        $pvm_tipsy_like_title = $pvm_data['pvm_tipsy_like_title'];
    }

    $pvm_tipsy_dislike_title = "Dislike The Post";

    // Dislike Bar Color.

    if (isset($pvm_data['pvm_tipsy_dislike_title']) && $pvm_data['pvm_tipsy_dislike_title'] != "") {

        $pvm_tipsy_dislike_title = $pvm_data['pvm_tipsy_dislike_title'];
    }


    if ($vote_given_status == 1) {

        $pvm_btn_container_html = '<div class="msg_container" id="msg_container_' . $post_id . '"> ' . esc_html__('Loading .....', 'bwl-pro-voting-manager') . '</div>';
    } else {

        if ($pvm_disable_down_vote_status == 1) {

            $pvm_btn_container_html = '<div class="btn_like" title="' . $pvm_tipsy_like_title . '" vote_status="1" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '">' . $pvm_like_thumb_html . '</div>';
        } else {

            $pvm_btn_container_html = '<div class="btn_like" title="' . $pvm_tipsy_like_title . '" vote_status="1" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '">' . $pvm_like_thumb_html . '</div>
                                               <div class="btn_dislike" title="' . $pvm_tipsy_dislike_title . '" vote_status="0" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '">' . $pvm_dislike_thumb_html . '</div>';
        }
    }


    /*--- BUILD INTERFACE---*/

    $bwl_pvm_voting_bar_type = ( get_post_meta($post_id, "bwl_pvm_voting_bar_type", true) == "" ) ? 0 : get_post_meta($post_id, "bwl_pvm_voting_bar_type", true);

    if ($bwl_pvm_voting_bar_type == 1 || $animation == 1) {

        // Custom Like Theme

        if ($like_theme != "") {

            $bwl_pvm_like_bar_theme = $like_theme;
        } else {

            $bwl_pvm_like_bar_theme = ( get_post_meta($post_id, "bwl_pvm_like_bar_theme", true) == "" ) ? 'animated_green_theme' : get_post_meta($post_id, "bwl_pvm_like_bar_theme", true);
        }

        // Custom Dislike Theme

        if ($dislike_theme != "") {

            $bwl_pvm_dislike_bar_theme = $dislike_theme;
        } else {

            $bwl_pvm_dislike_bar_theme = ( get_post_meta($post_id, "bwl_pvm_dislike_bar_theme", true) == "" ) ? 'animated_red_theme' : get_post_meta($post_id, "bwl_pvm_dislike_bar_theme", true);
        }


        $pvm_bar_html = '<div class="stat-bar">
                                    <div class="bpvm_animated_bar">
                                        <div class="bar like_percentage ' . $bwl_pvm_like_bar_theme . '" style="width:' . $like_percentage . '%;">
                                            <div class="barFill"></div>
                                        </div>
                                        <div class="bar dislike_percentage ' . $bwl_pvm_dislike_bar_theme . '" style="width:' . $dislike_percentage . '%;">
                                            <div class="barFill"></div>
                                        </div>
                                    </div>
                                </div><!-- end .stat-bar -->';
    } else {

        $pvm_bar_html = '<div class="stat-bar">'
                . '<div class="bg-green like_percentage" style="width:' . $like_percentage . '%;"></div>
                                    <div class="bg-red dislike_percentage" style="width:' . $dislike_percentage . '%;"></div>'
                . '</div><!-- end .stat-bar -->';
    }

    if ($pvm_disable_voting_bar_status == 1) {

        $pvm_bar_html = '<div class="stat-bar-blank"></div><!-- end .stat-bar-blank -->';
    }


    $pvm_like_count_container_string = '<div class="like-count-container">' . $pvm_like_thumb_html . ' <span>' . $like_vote_counter . '</span></div>';
    $pvm_dislike_count_container_string = '<div class="dislike-count-container">' . $pvm_dislike_thumb_html . ' <span>' . $dislike_vote_counter . '</span></div>';
    $pvm_store_dislike_string = $pvm_dislike_count_container_string; // create a backup for dislike count container string

    if ($pvm_disable_down_vote_status == 1 && $bwl_pvm_display_status != "" && $bwl_pvm_display_status != 3) {
        $pvm_dislike_count_container_string = "";
    }

    /*--- Voting Paused Checking---*/

    if ($bwl_pvm_display_status != "" && $bwl_pvm_display_status == 3) {
        $pvm_btn_container_html = '<p class="voting-paused-message"><i class="fa fa-info-circle"></i> ' . esc_html__("Voting Paused !", "bwl-pro-voting-manager") . '</p>';
    }

    /*--- User Role Filtering---*/

    if (isset($pvm_data ['pvm_role_status']['enabled']) && $pvm_data['pvm_role_status']['enabled'] == 'on') {

        //Fixed in version 1.1.2
        // Always admin user can submit vote.
        $pvm_enabled_roles = isset($pvm_data['pvm_role_status']['pvm_enabled_roles']) ? $pvm_data['pvm_role_status']['pvm_enabled_roles'] : array('administrator');

        $pvm_enabled_roles = array_map('strtolower', $pvm_enabled_roles);

        $pvm_current_use_info = wp_get_current_user();

        if (!array_intersect($pvm_enabled_roles, $pvm_current_use_info->roles)) {
            //stuff here for allowed roles
            $pvm_btn_container_html = '<p class="voting-paused-message"><i class="fa fa-warning"></i> ' . esc_html__("Sorry, You're not allowed to submit vote !", "bwl-pro-voting-manager") . '</p>';
            $pvm_dislike_count_container_string = $pvm_store_dislike_string;
        }
    }

    $pvm_custom_theme = "";

    if (isset($woo) && $woo == 1) {
        $pvm_custom_theme .= ' woo_pvm_theme';

        $pvm_alt_dislike_string = $pvm_dislike_count_container_string;

        if (isset($_GET['orderby']) && $_GET['orderby'] == "pvm_dislike_votes_count") {

            $pvm_dislike_count_container_string = $pvm_like_count_container_string;
            $pvm_like_count_container_string = $pvm_alt_dislike_string;
        }
    }


    $pvm_interface = '<section class="'.$bwl_pvm_container_class.' pvm_clearfix' . $pvm_custom_theme . '">
                                 <div class="pvm_btn_container pvm_clearfix" id="pvm_btn_container_' . $bpvm_unique_id . '"> 
                                    ' . $pvm_btn_container_html . '
                                 </div>
                                <div class="stat-cnt" id="stat-cnt-' . $bpvm_unique_id . '" data-result_percentage="'.$result_percentage.'">
                                    <div class="total-vote-counter">' . esc_html__("Total", "bwl-pro-voting-manager") . ' <span>' . $total_vote_counter . '</span> ' . esc_html__("Votes", "bwl-pro-voting-manager") . '</div>
                                        ' . $pvm_bar_html . '
                                        ' . $pvm_dislike_count_container_string . $pvm_like_count_container_string . '
                                </div>
                            </section>';

    if ($dpc == 1) {

        $post_info = get_post($post_id);

        $content .= do_shortcode('[video src="' . $post_info->post_content . '"][/video]');
    }

    $content .= $pvm_interface;

    $pvm_form_id = "pvm_feedback_form_" . $bpvm_unique_id;

    $captcha_status = 1;

    $pvm_captcha_generator = '<p>
                                                <label for="captcha">' . esc_html__('Captcha:', 'bwl-pro-voting-manager') . '</label>
                                                    <input id="num1" class="sum" type="text" name="num1" value="' . rand(1, 4) . '" readonly="readonly" /> +
                                                    <input id="num2" class="sum" type="text" name="num2" value="' . rand(5, 9) . '" readonly="readonly" /> =
                                                    <input id="captcha" class="captcha" type="text" name="captcha" maxlength="2" />
                                                    <input id="captcha_status" type="hidden" name="captcha_status" value="' . $captcha_status . '" />
                                                <span id="spambot"> ' . esc_html__('Verify Human or Spambot ?', 'bwl-pro-voting-manager') . '</span>
                                            </p>';

    //Fixed in version 1.1.4

    $pvm_disable_feedback_status = 0;
    $pvm_form_body = "";

    if (isset($pvm_data['pvm_disable_feedback_status']) && $pvm_data['pvm_disable_feedback_status'] == 1) {

        $pvm_disable_feedback_status = 1;
    }

    if ($pvm_disable_feedback_status == 0) {

        $pvm_form_body = '<section class="bwl-pro-voting-feedback-form-container pvm_clearfix" id="' . $pvm_form_id . '">
                    
                                        <h2>' . $pvm_feedback_form_title . ' </h2>

                                        <div class="bwl_pro_form_error_message_box"></div>
                                            
                                        <form id="bwl_pvm_feedback_form" class="bwl_pvm_feedback_form" name="bwl_pvm_feedback_form" method="post" action="#"> 
                                        
                                                <p>        
                                                    <textarea id="feedback_message" class="feedback_message_box" placeholder="' . esc_html__('Write feedback message ..... ', 'bwl-pro-voting-manager') . '"/></textarea>

                                                ' . $pvm_captcha_generator . '

                                                <p class="pvm_feedback_submit_container">
                                                    <input type="submit" value="' . esc_html__('Submit', 'bwl-pro-voting-manager') . '" tabindex="6" id="submit" name="submit" bwl_pvm_feedback_form_id= "' . $pvm_form_id . '" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '"/>
                                                </p>

                                                <input type="hidden" name="post_type" id="post_type" value="bwl_pro_voting_manager" />

                                                <input type="hidden" name="action" value="bwl_pro_voting_manager" />'
                . wp_nonce_field('name_of_my_action', 'name_of_nonce_field', true, false) .
                '</form>

                                        </section>';
    }



    $content .= $pvm_form_body;

    return $content;
}

// This shortcode will display liked/ disliked posts with limit and date filter
// PARAMETER INFO: 
// order_type: liked/disliked
// limit: no of post you want to display.
// date_filter: Allow to run date filter query
// interval: any number like 30, means display last 30 days top/down voted posts
// SHORTCODE EXAMPLES: 
// Display 20 top liked post of last 30 days : [bpvm_filter order_type='liked' limit=20 date_filter=1 interval=30 /]
// Display 20 top disliked  post of last 30 days : [bpvm_filter order_type='disliked' limit=20 date_filter=1 interval=30 /]

add_shortcode('bpvm_filter', 'cb_bpvm_filter');

function cb_bpvm_filter($atts) {

    global $post;

    $post_id = get_the_ID();

    $atts = shortcode_atts(array(
        'class' => 'bpvm-posts',
        'order_type' => 'liked', // liked/disliked
        'order' => 'ASC',
        'post_type' => 'post',
        'date_filter' => 0,
        'interval' => '1 week', // 1 day, 1 week, 1 month, custom(any date range)
        'vis' => date('Y-m-d'),
        'vie' => date('Y-m-d'),
        'limit' => 999999999,
        'animation' => 0,
        'custom_header' => 1,
        'thumb' => 1,
        'thumb_size' => 'pvm-post-thumb',
        'te_cat' => '',
        'voting_filter' => 1,
        'show_stats' => 1,
        'only_active' => 0,
        'vote_box' => 0,
            ), $atts);

    extract($atts);

    $pvm_voted_post_string = "";

    // New Voting Filter.
    // Introduced from version 1.1.0

    if ($interval == "1 week" || $interval == "1 day" || $interval == "1 month" || $interval == "custom") {

        global $wpdb;

        // @Vote type keys: 1=like, 2=dislike.
        // @Introduced in version : 1.1.0

        if ($order_type == "disliked") {

            $vote_type = 2;
        } else {

            $vote_type = 1;
        }

        // @Interval Ranges Script
        // @Introduced in version: 1.1.0
        // @Improved in version 1.1.3

        $post_table = $wpdb->prefix . "posts"; // posts table from database.

        if ($interval == 'custom') {

            // Custom Date Range.
//            bpvm_change_date_format($custom_date);
//            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `".$wpdb->prefix."bpvm_summary` WHERE 1 AND `post_type` = '{$post_type}' AND `vote_type`={$vote_type} AND 
//                `vote_date`>='{$vis}' AND `vote_date`<='{$vie}' GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";

            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
                    . "     WHERE 1 AND " . $wpdb->prefix . "bpvm_summary.postid = " . $post_table . ".ID"
                    . "     AND " . $post_table . ".post_status = 'publish'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
                    `vote_date`>='{$vis}' AND `vote_date`<='{$vie}' GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
        } else if ($interval == '1 month') {

            // 1 Month interval from current date.

            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
                    . "     WHERE 1 AND " . $wpdb->prefix . "bpvm_summary.postid = " . $post_table . ".ID"
                    . "     AND " . $post_table . ".post_status = 'publish'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
                " . $wpdb->prefix . "bpvm_summary.vote_date BETWEEN now() - interval 1 month AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
        } else if ($interval == '1 day') {

            // 1 day interval from current date.
//            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `".$wpdb->prefix."bpvm_summary` WHERE 1 AND `post_type` = '{$post_type}' AND `vote_type`={$vote_type} AND 
//                ".$wpdb->prefix."bpvm_summary.vote_date BETWEEN now() - interval 1 day AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";

            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
                    . "     WHERE 1 AND " . $wpdb->prefix . "bpvm_summary.postid = " . $post_table . ".ID"
                    . "     AND " . $post_table . ".post_status = 'publish'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
                " . $wpdb->prefix . "bpvm_summary.vote_date BETWEEN now() - interval 1 day AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
        } else {

            // // 1 Week interval from current date. ( Default )
//            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `".$wpdb->prefix."bpvm_summary` WHERE 1 AND `post_type` = '{$post_type}' AND `vote_type`={$vote_type} AND 
//                ".$wpdb->prefix."bpvm_summary.vote_date BETWEEN now() - interval 1 week AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";

            $query = "SELECT postid, SUM(`total_votes`) AS tv FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
                    . "     WHERE 1 AND " . $wpdb->prefix . "bpvm_summary.postid = " . $post_table . ".ID"
                    . "     AND " . $post_table . ".post_status = 'publish'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
                    . "     AND " . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
                " . $wpdb->prefix . "bpvm_summary.vote_date BETWEEN now() - interval 1 week AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
        }

        $query_results = $wpdb->get_results($query);

        if (count($query_results) > 0) :

            $counter = 1;

            $pvm_voted_post_string .= get_pvm_custom_header($custom_header);

            foreach ($query_results as $bpvm_filter_post_info) {

                $bpvm_post_id = $bpvm_filter_post_info->postid;

                $bpvm_post_total_votes = $bpvm_filter_post_info->tv;

                $post_thumb = '';

                if (has_post_thumbnail($bpvm_post_id) && $thumb == 1) {

                    $post_thumb = get_the_post_thumbnail($bpvm_post_id, $thumb_size);
                }

                $pvm_voted_post_string .= '<div class="pvm-custom-info">';
                
                $pvm_voting_box = "";
                
                if( $vote_box == 1 ) {
                      $pvm_voting_box .= do_shortcode('[bwl_pvm id='.$bpvm_post_id.' class="bpvm_filter_vbox"/]');
                }
                
                $pvm_voted_post_string .= '<div class="post-position">' . $counter . '</div>'
                        . '<div class="post-title"><a href="' . get_permalink($bpvm_post_id) . '" title="' . get_the_title($bpvm_post_id) . '" class="pvm-filtered-post">' . $post_thumb . '<span>' . get_the_title($bpvm_post_id) . '</span></a>'.$pvm_voting_box.'</div>'
                        . '<div class="post-votes">' . $bpvm_post_total_votes . '</div>';
                $pvm_voted_post_string .= '</div>';

                $counter++;
            }

        else :

            $pvm_voted_post_string = "<p>" . esc_html__("Sorry, No Post Found!", 'bwl-pro-voting-manager') . "</p>";

        endif;

        wp_reset_query();
    } else {


        // That filter Works for the older version.
        //     $te_cat = preg_replace('~&#x0*([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $te_cat);

        if ($order_type == "disliked") {

            $meta_key = 'pvm_dislike_votes_count';
        } else {

            $meta_key = 'pvm_like_votes_count';
        }
        
        //Default Arguments.
        
        $args = array(
            'post_status' => 'publish',
            'post_type' => $post_type,
            'order' => 'DESC',
            'meta_key' => $meta_key,
            'orderby' => 'meta_value_num',
            'posts_per_page' => $limit,
            'ignore_sticky_posts' => 1
        );
        
        // Allowed Only Active Meta Query.
        
        if ( isset($only_active) && $only_active == 1 ) {
            
            $args['meta_query'] = array(
                array(
                    'key' => 'bwl_pvm_display_status',
                    'compare' => '=',
                    'value' => 1,
                    'type' => 'numeric'
                )
            );
        
        }
        
        // Event Filter.
        if (class_exists('TribeEvents') && $post_type == "tribe_events" && $te_cat != "") {
            $args['tribe_events_cat'] = $te_cat;
        }
        //            
        if (isset($date_filter) && $date_filter == 1) {

            if (!is_numeric($interval)) {
                $interval = 30;
            }

            // Date Limit:
            $args ['meta_query'] = array(
                array(
                    'key' => 'vote_date',
                    'value' => date('Y-m-d', strtotime('-' . $interval . ' days')),
                    'compare' => '>='
                )
            );
        }
        //        
        if ($post_type == "post-format-gallery") {

            unset($args['post_type']); // unset post type field

            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'post_format',
                    'field' => 'slug',
                    'terms' => 'post-format-gallery'
                )
            );
        }

        $loop = new WP_Query($args);

        global $post;

        $counter = 1;

        if ($loop->have_posts()) :


            $pvm_voted_post_string .= get_pvm_custom_header($custom_header);

            while ($loop->have_posts()) :

                $loop->the_post();

                $post_thumb = '';

                if (has_post_thumbnail() && $thumb == 1) {
                    $post_thumb = get_the_post_thumbnail($post->ID, $thumb_size);
                }

                if ($order_type == "disliked") {

                    $pvm_dislike_votes_count = get_post_meta($post->ID, "pvm_dislike_votes_count", true);

                    $bpvm_post_total_votes = ( $pvm_dislike_votes_count == "" ) ? 0 : $pvm_dislike_votes_count;
                } else {

                    $pvm_like_votes_count = get_post_meta($post->ID, "pvm_like_votes_count", true);

                    $bpvm_post_total_votes = ( $pvm_like_votes_count == "" ) ? 0 : $pvm_like_votes_count;
                }


                $pvm_voted_post_string .= '<div class="pvm-custom-info">';

                $pvm_voted_post_string .= '<div class="post-position">' . $counter . '</div>'
                        . '<div class="post-title"><a href="' . get_permalink() . '" title="' . get_the_title() . '" class="pvm-filtered-post">' . $post_thumb . '<span>' . get_the_title() . '</span></a></div>'
                        . '<div class="post-votes">' . $bpvm_post_total_votes . '</div>';

                $pvm_voted_post_string .= '</div>';

                $counter++;

            endwhile;

            wp_reset_query();

        else:

            $pvm_voted_post_string = "<p>" . esc_html__("No Post Found!", 'bwl-pro-voting-manager') . "</p>";

        endif;
    }


    return $pvm_voted_post_string;
}

function get_pvm_custom_header($pvm_custom_header_status = 0) {

    $pvm_custom_header_string = "";

    if ($pvm_custom_header_status == 1) {
        $pvm_custom_header_string = '<div class="pvm-custom-header">'
                . '<div class="post-position">' . esc_html__('Position', 'bwl-pro-voting-manager') . '</div>'
                . '<div class="post-title">' . esc_html__('Title', 'bwl-pro-voting-manager') . '</div>'
                . '<div class="post-votes">' . esc_html__('Votes', 'bwl-pro-voting-manager') . '</div>'
                . '</div>';
    }

    return $pvm_custom_header_string;
}

/*---  PVM Result Counter---*/

add_shortcode('bpvm_results', 'cb_bpvm_results');

function cb_bpvm_results($atts) {

    global $post;

    $post_id = get_the_ID();

    extract(shortcode_atts(array(
        'show_like' => 1,
        'show_dislike' => 1,
        'show_icon' => 1
                    ), $atts));

    $pvm_data = get_option('bwl_pvm_options');

    /*--- Add Custom Icon For Like Button ---*/

    $pvm_like_results = "";

    if ($show_like == 1) {

        $like_vote_counter = bpvm_get_vote_counts_meta($post_id);

        if ($like_vote_counter == "") {
            $like_vote_counter = 0;
        }

        if (isset($pvm_data ['pvm_like_thumb_icon']) && $pvm_data ['pvm_like_thumb_icon'] != "") {

            $pvm_like_thumb_icon = $pvm_data ['pvm_like_thumb_icon'];

            $pvm_like_results .= '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i> ';
        } else {

            $pvm_like_thumb_icon = "fa-thumbs-o-up";

            $pvm_like_results .= '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i> ';
        }

        $pvm_like_results .= $like_vote_counter . ' ';
    }

    /*--- Add Custom Icon For Dislike Button ---*/

    $pvm_dislike_results = "";

    if ($show_dislike == 1) {

        $dislike_vote_counter = bpvm_get_vote_counts_meta($post_id, 2);

        if ($dislike_vote_counter == "") {
            $dislike_vote_counter = 0;
        }

        if (isset($pvm_data ['pvm_dislike_thumb_icon']) && $pvm_data ['pvm_dislike_thumb_icon'] != "") {

            $pvm_dislike_thumb_icon = $pvm_data ['pvm_dislike_thumb_icon'];

            $pvm_dislike_results .= '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i> ';
        } else {

            $pvm_dislike_thumb_icon = "fa-thumbs-o-down";

            $pvm_dislike_results .= '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i> ';
        }

        $pvm_dislike_results .= $dislike_vote_counter;
    }


    $pvm_result_string = $pvm_like_results . $pvm_dislike_results;

    return $pvm_result_string;
}

//@Create a list and allow user to submit votes.
//@Since: version 1.1.2

add_shortcode('pvm_lists', 'cb_pvm_lists');

function cb_pvm_lists($atts) {

    extract(shortcode_atts(array(
        'ids' => '',
        'title_tag' => 'h4',
        'show_number' => 0
                    ), $atts));

    $ids_lists = explode(',', $ids);
    $title_tag_style = "";
    $output = "";

    if (count($ids_lists) > 0) {

        $item_number = 1;

        foreach ($ids_lists as $id) {
            
            $bwl_pvm_display_status = get_post_meta($id, 'bwl_pvm_display_status', true);
            
            if (isset($bwl_pvm_display_status) && $bwl_pvm_display_status != 0) {

                $item_number_html = ( $show_number == 1 ) ? $item_number++ . '. ' : '';

                $post_title = get_the_title($id);
                $post_url = get_the_permalink($id);


                $output .= '<' . $title_tag . ' ' . $title_tag_style . '><a href="' . $post_url . '">' . $item_number_html . $post_title . '</a></' . $title_tag . '>';

                $output .= do_shortcode('[bwl_pvm id=' . $id . ' status="' . $bwl_pvm_display_status . '"/]');
            }
            
        }
    }
    return $output;
}

//@Create a list of top liked and disliked posts from a specific category. You can include multiple categories from a post type.
//@Since: version 1.1.7
// @Shortcode: [pvm_taxonomy_filter taxonomy_cats="your-cat-slug"]


add_shortcode('pvm_taxonomy_filter', 'cb_pvm_taxonomy_filter');

function cb_pvm_taxonomy_filter($atts) {

    $atts = shortcode_atts(array(
        'title_tag' => 'h4',
        'show_number' => 1,
        'post_type' => 'post',
        'meta_key' => 'like',
        'taxonomy' => 'category',
        'taxonomy_cats' => '',
        'posts_per_page' => -1
            ), $atts);

    extract($atts);

    $meta_key = ( isset($meta_key) && $meta_key == "dislike" ) ? 'pvm_dislike_votes_count' : 'pvm_like_votes_count';

    $args = array(
        'post_status' => 'publish',
        'post_type' => $post_type,
        'meta_key' => $meta_key,
        'order' => 'DESC',
        'orderby' => 'meta_value_num',
        'posts_per_page' => $posts_per_page,
        'ignore_sticky_posts' => 1,
        'meta_query' => array(
            array(
                'key' => 'bwl_pvm_display_status',
                'value' => 1,
                'compare' => '=',
            ),
        )
    );

    if (isset($taxonomy_cats) && $taxonomy_cats != "") {

        $taxonomy_cats = explode(',', $taxonomy_cats);

        $args['tax_query'] = array(
            'relation' => 'AND',
            array(
                'taxonomy' => $taxonomy,
                'field' => 'slug',
                'terms' => $taxonomy_cats,
                'include_children' => 0,
                'operator' => 'IN'
            )
        );
    }

    $loop = new WP_Query($args);

    global $post;

    $output = "";

    $title_tag_style = "";

    if ($loop->have_posts()) :

        $item_number = 1;

        while ($loop->have_posts()) :

            $loop->the_post();

            $id = get_the_ID();

            $post_title = get_the_title();

            $post_url = get_the_permalink($id);

            $item_number_html = ( $show_number == 1 ) ? $item_number++ . '. ' : '';

            $output .= '<' . $title_tag . ' ' . $title_tag_style . '><a href="' . $post_url . '">' . $item_number_html . $post_title . '</a></' . $title_tag . '>';

            $output .= do_shortcode('[bwl_pvm id=' . $id . '/]');

        endwhile;

    endif;

    return $output;
}




add_shortcode('bpvm_stat', 'cb_bpvm_stat');

function cb_bpvm_stat( $atts ) {
    extract(shortcode_atts(array(
        'post_type_filter' => 0,
        'post_type' => 'post',
        'month_range' => 1
                    ), $atts));

    global $wpdb;
    $post_table = $wpdb->prefix . "posts"; // posts table from database.
    $order = "DESC";


    $post_type_filter_query = '';

    if ($post_type_filter == 1) {
        $post_type_filter_query .= " " . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}' AND ";
    }


    $query = "SELECT {$post_table}.ID FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
            . "     WHERE 1 AND "
            . $wpdb->prefix . "bpvm_summary.postid = {$post_table}.ID AND "
            . " {$post_table}.post_status = 'publish' AND "
            . $post_type_filter_query .
            " {$post_table}.post_date BETWEEN now() - interval {$month_range} month AND now() GROUP BY {$post_table}.ID";


    $query_results = $wpdb->get_results($query);
    $total_posts_published = "<li>" . __('Total Posts Published:', 'bwl-pro-voting-manager') . $wpdb->num_rows . "</li>";

    wp_reset_query();


    $query = "SELECT SUM(`total_votes`) AS liked_votes FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
            . "  WHERE 1 AND "
            . $wpdb->prefix . "bpvm_summary.postid = {$post_table}.ID AND "
            . " {$post_table}.post_status = 'publish' AND "
            . $post_type_filter_query .
            " " . $wpdb->prefix . "bpvm_summary.vote_type=1 AND " .
            "{$post_table}.post_date BETWEEN now() - interval {$month_range} month AND now() ORDER BY liked_votes {$order}";


    $query_results = $wpdb->get_results($query);
    $total_like_votes = "<li>" . __('Total Like Votes:', 'bwl-pro-voting-manager') . $query_results[0]->liked_votes . "</li>";

    wp_reset_query();


    $query = "SELECT SUM(`total_votes`) AS disliked_votes FROM `" . $wpdb->prefix . "bpvm_summary`,`" . $post_table . "` "
            . "  WHERE 1 AND "
            . $wpdb->prefix . "bpvm_summary.postid = {$post_table}.ID AND "
            . " {$post_table}.post_status = 'publish' AND "
            . $post_type_filter_query .
            " " . $wpdb->prefix . "bpvm_summary.vote_type=2 AND " .
            "{$post_table}.post_date BETWEEN now() - interval {$month_range} month AND now() ORDER BY disliked_votes {$order}";


    $query_results = $wpdb->get_results($query);
    $total_dislike_votes = "<li>" . __('Total Dislike Votes:', 'bwl-pro-voting-manager') . $query_results[0]->disliked_votes . "</li>";

    wp_reset_query();

    $final_output = '';

    $final_output .= '<div class="bpvm-vote-stats">';
    $final_output .= '<ul>';
    $final_output .= $total_posts_published;
    $final_output .= $total_like_votes;
    $final_output .= $total_dislike_votes;
    $final_output .= '</ul>';
    $final_output .= '</div>';

    return $final_output;
}
