<?php

add_action( 'admin_init', 'pvm_generate_csv' );

/**
 * Process content of CSV file
 *
 * @since 0.1
 * */
function pvm_generate_csv() {
    
    if (isset($_POST['_wpnonce-pvm-voting-data-export'])) {
        
        check_admin_referer('pvm-voting-data-export', '_wpnonce-pvm-voting-data-export');
        
        
        global $wpdb;
        $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
        $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.   

        $post_id = $_POST['mv_post_title']; // Get post ID 
        $post_type = isset( $_POST['mv_bpvm_post_type'] ) ? $_POST['mv_bpvm_post_type'] : ''; // WordPress Available Post Types.
        $mv_post_filters = isset( $_POST['mv_post_filters'] ) ? $_POST['mv_post_filters'] : ''; // Filter Type: Like/Dislike.
        $mv_vote_info_type = isset( $_POST['mv_vote_info_type'] ) ? $_POST['mv_vote_info_type'] : ''; // Voting Info type: Summary/ Details
        $pvm_custom_date_range = isset( $_POST['pvm_custom_date_range'] ) ? $_POST['pvm_custom_date_range'] : ''; // Get Custom Date range status.
        $pvm_filter_start_date = isset( $_POST['pvm_filter_start_date'] ) ? $_POST['pvm_filter_start_date'] : ''; // Starting date of filter.
        $pvm_filter_end_date = isset( $_POST['pvm_filter_end_date'] ) ? $_POST['pvm_filter_end_date'] : ''; // Ending date of filter.
        
        // Get total votes/likes/dislikes count displaying in front end.
        // @Since: version 1.1.2

        $pvm_like_votes_count = bpvm_get_vote_counts_meta($post_id);

        if ( $pvm_like_votes_count == "" ) {
            $pvm_like_votes_count = 0;
        }

        $pvm_dislike_votes_count = bpvm_get_vote_counts_meta($post_id, 2);

        if ( $pvm_dislike_votes_count == "" ) {
            $pvm_dislike_votes_count = 0;
        }

        // End of total votes count.

        $vars = array($post_id, $post_type);

        $con_mv_post_filters = "";

        if ($mv_post_filters != "") {
            $con_mv_post_filters .= " AND vote_type = %d ";
            $vars[] = $mv_post_filters;
        }

        $con_mv_date_range_filters = "";

        if ($pvm_custom_date_range == "true") {
            $pvm_filter_start_date = ( $pvm_filter_start_date == "" ) ? "2010-04-01" : $pvm_filter_start_date;
            $pvm_filter_end_date = ( $pvm_filter_end_date == "" ) ? "2020-04-01" : $pvm_filter_end_date;

            $con_mv_date_range_filters .= " AND DATE(vote_date) >= %s AND DATE(vote_date) <= %s ";

            $vars[] = $pvm_filter_start_date;
            $vars[] = $pvm_filter_end_date;
        }

        $mv_btn_del_string = " - ";


        if ($mv_vote_info_type == 2) {

            // Get each votes info in details. ( Details )

            $sql = $wpdb->prepare("SELECT ID, postid, vote_date, DATE(vote_date) as only_date, vote_type, votes FROM {$bpvm_voting_data_table} 
                    WHERE postid = %d 
                    AND post_type = %s 
                    " . $con_mv_post_filters . "
                    " . $con_mv_date_range_filters . "
                    ORDER BY vote_date DESC", $vars);
        } else {

            // Only count the total votes. ( Summary )

            $sql = $wpdb->prepare("SELECT postid, vote_date, vote_type, total_votes as votes FROM {$bpvm_voting_summary_table}   
                    WHERE postid = %d 
                    AND post_type = %s 
                    " . $con_mv_post_filters . "
                    " . $con_mv_date_range_filters . "
                    ORDER BY vote_date DESC", $vars);
        }

        // Generate data from query.

        $pvm_votes_data = $wpdb->get_results($sql, ARRAY_A);
        

        $pvm_filtered_data = array();

        $pvm_backend_likes = 0;
        $pvm_backend_dislikes = 0;

        if (sizeof($pvm_votes_data) > 0) :

            foreach ($pvm_votes_data as $vote_data) :

                $post_id = $vote_data['postid'];

                if ($mv_vote_info_type == 2) {

                    $row_id = $vote_data['ID'];
                    $only_date = $vote_data['only_date'];
                    $vote_type = $vote_data['vote_type'];
                    $votes = $vote_data['votes'];

                }

                // Start Backend total like/dislike vote counting.

                if( $vote_data['vote_type'] == 2 ) {

                    $pvm_backend_dislikes+=$vote_data['votes'];

                } else if ( $vote_data['vote_type'] == 1 ) {

                    $pvm_backend_likes+=$vote_data['votes'];

                } else {

                    // Do nothing.

                }

                // End of backend total vote counting.

                array_push($pvm_filtered_data, array( 
                    $post_id,
                    $post_type,
                    $vote_data['vote_date'],
                    ( $vote_data['vote_type'] == 2 ) ? esc_html__('Dislike', 'bwl-pro-voting-manager') : esc_html__('Like', 'bwl-pro-voting-manager'),
                    $vote_data['votes']
                ));

            endforeach;

        endif;

        wp_reset_query();

//        $data = array(
//            'pvm_backend_likes' => $pvm_backend_likes,
//            'pvm_backend_dislikes' => $pvm_backend_dislikes,
//            'pvm_front_likes' =>$pvm_like_votes_count, // Number of likes count displaying in front end.
//            'pvm_front_dislikes' =>$pvm_dislike_votes_count // Number of dislikes count displaying in front end.
//        ); 
        
        $output_file_name = 'pvm_data.' . date('Y-m-d-H-i-s') . '.csv';

        header('Content-Description: File Transfer');
        header('Content-Disposition: attachment; filename=' . $output_file_name);
        header('Content-Type: text/csv; charset=' . get_option('blog_charset'), true);
        
        $input_array = $pvm_filtered_data;
        
        $delimiter = ',';

        /** open raw memory as file, no need for temp files, be careful not to run out of memory thought */
        $f = fopen('php://memory', 'w');
        /** loop through array  */
        foreach ($input_array as $line) {
            /** default php csv handler **/
            fputcsv($f, $line, $delimiter);
        }
        /** rewrind the "file" with the csv lines **/
        fseek($f, 0);
        /** modify header to be downloadable csv file **/
        header('Content-Type: application/csv');
        header('Content-Disposition: attachement; filename="' . $output_file_name . '";');
        /** Send file to browser for download */
        fpassthru($f);
        exit;
    }
}

add_action('wp_ajax_bpvm_get_posts_data', 'bpvm_get_posts_data');

function bpvm_get_posts_data() {

    $args = array(
        'post_type' => $_POST['post_type'],
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order' => 'ASC'
    );

    $query = new WP_Query($args);

    $post_data = array();


    if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();

            $post_data['status'] = 1;
            $post_data['data'][] = array('post_id' => get_the_ID(),
                'post_title' => get_the_title()
            );

        endwhile;

    else :
        $post_data['status'] = 0;
    endif;

    echo json_encode($post_data);

    wp_reset_query();  //reset the query   

    die();
}

// Single Post Info.

add_action('wp_ajax_bpvm_get_single_post_data', 'bpvm_get_single_post_data');

function bpvm_get_single_post_data() {

    $post_id = $_POST['post_id'];
    $post_type = trim($_POST['post_type']);

    $like_vote_counter = bpvm_get_vote_counts_meta($post_id);
    $total_likes = ( $like_vote_counter == "" ) ? 0 : $like_vote_counter;

    $dislike_vote_counter = bpvm_get_vote_counts_meta($post_id, 2);
    $total_dislikes = ( $dislike_vote_counter == "" ) ? 0 : $dislike_vote_counter;

    global $wpdb;

    $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.

    $order = "DESC";

    $sql = $wpdb->prepare("SELECT* FROM {$bpvm_voting_data_table} 
                WHERE postid = %d 
                AND post_type = %s 
                ORDER BY vote_date DESC", $post_id, $post_type);
    $report_data = $wpdb->get_results($sql);


    $post_data = array();

    $post_data['status'] = 1;
    $post_data['data'] = array('likes' => $total_likes,
        'dislikes' => $total_dislikes,
        'report_data' => $report_data
    );

    echo json_encode($post_data);

    wp_reset_query();  //reset the query   

    die();
}

/***********************************************************************************************/
/* @ Description: Integrate Voting Report Submenu With Voting Manager Menu Section 
 * @ Since: 1.1.1
 * @ Introduced: 20-10-2015
 * @ Last Update: 06-11-2015
 *  */
/***********************************************************************************************/

add_action('admin_menu', 'bpvm_voting_report_submenu');

function bpvm_voting_report_submenu() {

    /*
     * @ Enqueue All Required Scripts For Reporting Page.
     * @ Since : Version 1.1.1
     */

    

    $page = add_submenu_page(
            'bwl-pvm', // unique slug for plugin settings menu.
            esc_html__('Voting Report Manager', 'bwl-pro-voting-manager'), // The Text to be display in bte browser bar.
            esc_html__('Voting Report', 'bwl-pro-voting-manager'), // The Text to be display in bte browser bar.
            'manage_options', // Permission.,
            'bpvm-voting-report', 
            'cb_bpvm_voting_report' // Settings Page,
    );
    
    

    /* Using registered $page handle to hook stylesheet loading */
    add_action('admin_print_styles-' . $page, 'bpvm_report_page_styles');
    
//    if(isset($_GET['page']) && $_GET['page'] == 'bpvm-voting-report') {
//        add_action('admin_notices', 'bpvm_date_filter_admin_notice');
//        add_action('admin_init', 'bpvm_voting_filter_ignore_admin_notice');
//    }
}

function bpvm_report_page_styles() {
    /*
     * It will be called only on your plugin admin page, enqueue our stylesheet here
     */
    
    wp_enqueue_style( 'bwl-pvm-jquery-ui-style');
    wp_enqueue_style('bwl-pvm-datatables-style');
}

/* * ******************************************************************************************** */
/* Voting Report Sub Menu Page */
/* * ******************************************************************************************** */

function cb_bpvm_voting_report() {
    
    wp_enqueue_script('bpvm-datatable-script');
    wp_enqueue_script('bpvm-admin-voting-report-script');
    require_once ( __DIR__ . '/views/view-voting-report.php');
    
}


// @Description: Make user voting date more human friendly.
// @Since: Version 1.1.2

function pvm_human_date_format( $date ) {
    return $date;
    $date_info = explode(' ', $date);
   
    
    if( count( $date_info ) == 2 ) {
        
        // With Time Info.
        $final_date_info = explode('-', $date_info[0]);
        $time_info = ' '.$date_info[1];
        
    } else {
        
        // Without Time Info.
        $final_date_info = explode('-', $date_info[0]);
        $time_info = "";
        
    }
    
    return $final_date_info[2] . '-' . $final_date_info[1] . '-' . $final_date_info[0] . $time_info;
    
}


//@Description: Generate Voting Data in data grid.
//@Since: Version 1.1.1

add_action('wp_ajax_pvm_voting_stats', 'pvm_voting_stats');

function pvm_voting_stats() {

        global $wpdb;
        $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
        $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.

        $requestData = $_POST;
        $data = array();

        $columns = array(
            0 => 'ID',
            1 => 'vote_date',
            2 => 'vote_type',
            3 => 'votes'
        );

        $post_id = $_POST['post_id']; // Get post ID 
        $post_type = $_POST['post_type']; // WordPress Available Post Types.
        $mv_post_filters = $_POST['mv_post_filters']; // Filter Type: Like/Dislike.
        $mv_vote_info_type = $_POST['mv_vote_info_type']; // Voting Info type: Summary/ Details
        $pvm_custom_date_range = $_POST['pvm_custom_date_range']; // Get Custom Date range status.
        $pvm_filter_start_date = $_POST['pvm_filter_start_date']; // Starting date of filter.
        $pvm_filter_end_date = $_POST['pvm_filter_end_date']; // Ending date of filter.


        // New Code Implemented In Version 1.1.4

        $vars = array($post_id,$post_type);


        if ( $mv_vote_info_type == 2 ) {

            // Only count the total votes. ( Details )

            $bpvm_selected_columns = 'ID,postid,post_type,vote_type,votes, DATE(vote_date) as vote_date';

        } else {

            // Only count the total votes. ( Summary )

            $bpvm_voting_data_table =  $bpvm_voting_summary_table;

            $bpvm_selected_columns = 'ID,postid,vote_date,vote_type,total_votes as votes ';

        }
    
    
        // Start Query Conditions.

       $con_mv_date_range_filters = "";
       
       if ($mv_post_filters != "") {
           $con_mv_post_filters .= " AND vote_type = %d ";
           $vars[] = $mv_post_filters;
       }

       if ($pvm_custom_date_range == "true") {

           $pvm_filter_start_date = ( $pvm_filter_start_date == "" ) ? "2010-04-01" : $pvm_filter_start_date;
           $pvm_filter_end_date = ( $pvm_filter_end_date == "" ) ? "2020-04-01" : $pvm_filter_end_date;

           $con_mv_date_range_filters .= " AND DATE(vote_date) >= %s AND DATE(vote_date) <= %s ";

           $vars[] = $pvm_filter_start_date;
           $vars[] = $pvm_filter_end_date;
       }


       // End Query Conditions.

       $count_sql = $wpdb->prepare("SELECT COUNT(ID) AS total_count FROM {$bpvm_voting_data_table} 
                                                               WHERE postid = %d 
                                                               AND post_type = %s 
                                                               " . $con_mv_post_filters . "
                                                               " . $con_mv_date_range_filters . "", $vars);


       // Generate data from query.

       $bpvm_total_votes = $wpdb->get_results($count_sql, ARRAY_A);

//               echo $wpdb->last_query;

       wp_reset_vars($vars);
       wp_reset_query();

       $totalData = (!empty($bpvm_total_votes[0]['total_count']) ) ? $bpvm_total_votes[0]['total_count'] : 0;
       $totalFiltered = $totalData;  // when there is no search parameter then total number rows = total number filtered rows.
       //
           // Get each votes info in details. ( Details )

       $order_query = " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

       if ( $mv_vote_info_type != 2 ) {
            $extra_condition = 'AND total_votes != %d ';
            $vars[] = '0';
       }
       
       $sql = $wpdb->prepare("SELECT ".$bpvm_selected_columns." FROM {$bpvm_voting_data_table} 
                   WHERE postid = %d 
                   AND post_type = %s 
                   " . $extra_condition . "
                   " . $con_mv_post_filters . "
                   " . $con_mv_date_range_filters . $order_query . "", $vars);

       // Generate data from query.

       $pvm_vote_data = $wpdb->get_results($sql, ARRAY_A);

       $bpvm_full_vote_data = array();

       if (sizeof($pvm_vote_data) > 0) :

           $i = 1 + $requestData['start'];

           foreach ($pvm_vote_data as $vote_data) :

               $row_id = $vote_data['ID']; // auto incremental ID.
               $post_id = $vote_data['postid'];
               $vote_type = $vote_data['vote_type'];
               $votes = $vote_data['votes'];
               $vote_date = $vote_data['vote_date'];

               // End of backend total vote counting.

               array_push($bpvm_full_vote_data, array(
                 ( $mv_vote_info_type == 2 )  ? '<input type="checkbox"  class="deleteRow" value="' . $row_id . '" data-post_id="' . $post_id . '" data-votes="' . $votes . '" data-vote_type="' . $vote_type . '" data-vote_date="' . $vote_date . '"/>': '-',
                   $vote_date,
                   ( $vote_type == 2 ) ? esc_html__('Dislike', 'bwl-pro-voting-manager') : esc_html__('Like', 'bwl-pro-voting-manager'),
                   $votes
               ));

               $i++;

           endforeach;

       endif;

       wp_reset_vars($vars);
       wp_reset_query();


       $data = array(
            "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
            "recordsTotal" => intval($totalData), // total number of records
            "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
            'data' => $bpvm_full_vote_data
        );
    
    echo json_encode($data);
    die();
    
}


// @Description: Manual updates of voting data.
// @Since: Version 1.1.1

add_action('wp_ajax_bpvm_update_vote_data', 'bpvm_update_vote_data');

function bpvm_update_vote_data() {

    global $wpdb;
    $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
    $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.   
    $pvm_current_date = date("Y-m-d");
//     $pvm_current_date_time =  date("H:i:s");

    $post_id = $_POST['post_id'];
    $post_type = $_POST['post_type'];
    $pvm_mv_date = $_POST['pvm_mv_date'];
    $pvm_mv_vote_type = $_POST['pvm_mv_vote_type'];
    $pvm_manual_votes = is_numeric($_POST['pvm_manual_votes']) ? $_POST['pvm_manual_votes'] : 0;

    if ($pvm_mv_vote_type == 1) {

        $pvm_liked_votes_by_date = get_post_meta($post_id, "pvm_liked_votes_by_date");  // Get Liked vote per date wise for the current post  

        if (!empty($pvm_liked_votes_by_date)) {

            $pvm_liked_votes_by_date_info = $pvm_liked_votes_by_date[0];
        } else {

            $pvm_liked_votes_by_date_info = array();
        }

        if (!empty($pvm_liked_votes_by_date) && in_array($pvm_current_date, array_keys($pvm_liked_votes_by_date[0]))) {

            $pvm_like_vote_update_status = 1;

            $pvm_liked_votes_by_date_counter = $pvm_liked_votes_by_date[0][$pvm_current_date]; // store meta submission counter value.
            $pvm_liked_votes_by_date_info[$pvm_current_date] = $pvm_liked_votes_by_date_counter + $pvm_manual_votes;
        } else {

            $pvm_like_vote_update_status = 0;

            $pvm_liked_votes_by_date_counter = 0; // if no one submitted voted yet, initialize pvm_submission_counter variable.
            $pvm_liked_votes_by_date_info[$pvm_current_date] = $pvm_liked_votes_by_date_counter + $pvm_manual_votes;
        }


        // Like Votes

        $like_vote_counter = bpvm_get_vote_counts_meta($post_id);
        $total_likes = ( $like_vote_counter == "" ) ? $pvm_manual_votes : $like_vote_counter + $pvm_manual_votes;
        update_post_meta($post_id, "pvm_liked_votes_by_date", $pvm_liked_votes_by_date_info);
        update_post_meta($post_id, "pvm_like_votes_count", $total_likes);
        update_post_meta($post_id, "vote_date", $pvm_current_date);
        wp_reset_query();
    } else if ($pvm_mv_vote_type == 2) {

        $pvm_disliked_votes_by_date = get_post_meta($post_id, "pvm_disliked_votes_by_date");  // Get Disliked vote per date wise for the current post  

        if (!empty($pvm_disliked_votes_by_date)) {

            $pvm_disliked_votes_by_date_info = $pvm_disliked_votes_by_date[0];
        } else {

            $pvm_disliked_votes_by_date_info = array();
        }

        if (!empty($pvm_disliked_votes_by_date) && in_array($pvm_current_date, array_keys($pvm_disliked_votes_by_date[0]))) {

            $pvm_dislike_vote_update_status = 1;

            $pvm_disliked_votes_by_date_counter = $pvm_disliked_votes_by_date[0][$pvm_current_date]; // store meta submission counter value.
            $pvm_disliked_votes_by_date_info[$pvm_current_date] = $pvm_disliked_votes_by_date_counter + $pvm_manual_votes;
        } else {

            $pvm_dislike_vote_update_status = 0;

            $pvm_disliked_votes_by_date_counter = 0; // if no one submitted voted yet, initialize pvm_submission_counter variable.
            $pvm_disliked_votes_by_date_info[$pvm_current_date] = $pvm_disliked_votes_by_date_counter + $pvm_manual_votes;
        }

        // Dislike Votes.

        $dislike_vote_counter = bpvm_get_vote_counts_meta($post_id, 2);
        $total_dislikes = ( $dislike_vote_counter == "" ) ? $pvm_manual_votes : $dislike_vote_counter + $pvm_manual_votes;
        update_post_meta($post_id, "pvm_disliked_votes_by_date", $pvm_disliked_votes_by_date_info);
        update_post_meta($post_id, "pvm_dislike_votes_count", $total_dislikes);
        update_post_meta($post_id, "vote_date", $pvm_current_date);
        wp_reset_query();
    }

    /* ------------------------------  INSERT DATA IN TO SUMMARY TABLE. --------------------------------- */

    $sql = $wpdb->prepare("SELECT id, total_votes FROM {$bpvm_voting_summary_table} 
                                            WHERE postid = %d 
                                            AND post_type = %s 
                                            AND vote_date = %s 
                                            AND vote_type = %d 
                                            ORDER BY vote_date DESC", $post_id, $post_type, $pvm_mv_date, $pvm_mv_vote_type);
    $bpvm_voting_summary_data = $wpdb->get_results($sql, ARRAY_A);

    if (count($bpvm_voting_summary_data) > 0) {

        //Update Data

        $wpdb->update(
                $bpvm_voting_summary_table, array(
            'total_votes' => $bpvm_voting_summary_data[0]['total_votes'] + $pvm_manual_votes
                ), // Data – array of data to update as column->value pairs
                array('id' => $bpvm_voting_summary_data[0]['id']), //Where – array of data to match as column->value pairs
                array('%d'), // Data Format 
                array('%d') // Where Format 
        );
    } else {

        // Insert  Data

        $wpdb->insert(
                $bpvm_voting_summary_table, array(
            'postid' => $post_id,
            'post_type' => $post_type,
            'vote_type' => $pvm_mv_vote_type, // like=1, dislike=2
            'vote_date' => $pvm_mv_date,
            'total_votes' => $pvm_manual_votes, // default is 1.
            'last_voted' => $pvm_mv_date . ' ' . date("H:i:s")
                ), array('%d', '%s', '%d', '%s', '%d', '%s')
        );
    }

    wp_reset_query();

    /* ------------------------------ INSERT DATA IN TO VOTING DATA TABLE  --------------------------------- */
    
    $current_user = wp_get_current_user();
    $user_id = $current_user->ID;

    $wpdb->insert(
            $bpvm_voting_data_table, 
            array(
                    'postid' => $post_id,
                    'post_type' => $post_type,
                    'vote_type' => $pvm_mv_vote_type, // like=1, dislike=2
                    'votes' => $pvm_manual_votes, // default is 1.
                    'vote_date' => $pvm_mv_date . ' ' . date("H:i:s"),
                    'voted_ip' => $_SERVER['REMOTE_ADDR'],
                    'user_id' => $user_id
            ), array('%d', '%s', '%d', '%d','%s','%s','%d')
    );

    wp_reset_query();

    $post_data = array();

    $post_data['status'] = 1;
    
    // Added in version 1.1.4
    
    $total_likes = bpvm_get_vote_counts_meta($post_id);
    $total_dislikes = bpvm_get_vote_counts_meta($post_id, 2);
    
    update_post_meta($post_id, "pvm_total_votes", ( $total_likes+$total_dislikes) );

    echo json_encode($post_data);

    die();
}

/* ------------------------------ DELETE VOTES  --------------------------------- */


add_action('wp_ajax_bpvm_delete_vote_data', 'bpvm_delete_vote_data');
add_action('wp_ajax_nopriv_bpvm_delete_vote_data', 'bpvm_delete_vote_data');

function bpvm_delete_vote_data() {

    global $wpdb;
    $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
    $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.   
    
    // GET POST DATA.
    
    $post_type = $_POST['post_type'];
    $post_id = $_POST['post_id'];
    $bpvm_data_stack = $_POST['bpvm_data_stack'];
    $bpvm_undo_vote = 0;
    
    if( isset( $_POST['bpvm_undo_vote'] ) && $_POST['bpvm_undo_vote'] == 1 ) {
        $bpvm_undo_vote = 1;
    }
    
    //--------- ARRAY DATA STACK SEQUENCES ---------//
    // 0= row_id
    // 1=votes.
    // 2=vote_type
    // 3=vote_date
    
    $loop_counter =0;
    foreach ( $bpvm_data_stack as $data_stack ) {
        $loop_counter++;
        
        $row_id = $data_stack[0];
        $votes = $data_stack[1];
        $pvm_mv_vote_type = $data_stack[2];
        $vote_date = $data_stack[3];
        
        //-------- Start Remvoe Functions --------//
        
        if ($pvm_mv_vote_type == 1) {

            // Like Votes

            $like_vote_counter = bpvm_get_vote_counts_meta($post_id);
            $pre_total_likes = ( $like_vote_counter == "" ) ? 0 : $like_vote_counter - $votes;
            $total_likes = ( $pre_total_likes < 0 ) ? 0 : $pre_total_likes;
            update_post_meta($post_id, "pvm_like_votes_count", $total_likes);
            wp_reset_query();
            
        } else if ($pvm_mv_vote_type == 2) {

            // Dislike Votes.

            $dislike_vote_counter = bpvm_get_vote_counts_meta($post_id, 2);
            $pre_total_dislikes = ( $dislike_vote_counter == "" ) ? 0 : $dislike_vote_counter - $votes;
            $total_dislikes = ( $pre_total_dislikes < 0 ) ? 0 : $pre_total_dislikes;
            update_post_meta($post_id, "pvm_dislike_votes_count", $total_dislikes);
            wp_reset_query();
            
        }

        /* ------------------------------  GET DATA FROM SUMMARY TABLE. --------------------------------- */

        $sql = $wpdb->prepare("SELECT id, total_votes FROM {$bpvm_voting_summary_table} 
                                            WHERE postid = %d 
                                            AND post_type = %s 
                                            AND vote_date = %s 
                                            AND vote_type = %d 
                                            ORDER BY vote_date DESC LIMIT 1", $post_id, $post_type, $vote_date, $pvm_mv_vote_type);
        $bpvm_voting_summary_data = $wpdb->get_results($sql, ARRAY_A);

        if (count($bpvm_voting_summary_data) > 0) {

            //Update Data

            $pre_total_votes = $bpvm_voting_summary_data[0]['total_votes'] - $votes;
            $new_total_votes = ( $pre_total_votes < 0 ) ? 0 : $pre_total_votes;

            $wpdb->update(
                    $bpvm_voting_summary_table, array(
                      'total_votes' => $new_total_votes
                    ), // Data – array of data to update as column->value pairs
                    array('ID' => $bpvm_voting_summary_data[0]['id']), //Where – array of data to match as column->value pairs
                    array('%d'), // Data Format 
                    array('%d') // Where Format 
            );

            if ($pvm_mv_vote_type == 1) {

                // Again Update LikedPost Meta Table Values. 
                $pvm_liked_votes_by_date_info = array();
                $pvm_liked_votes_by_date_info[$vote_date] = $new_total_votes;
                update_post_meta($post_id, "pvm_liked_votes_by_date", $pvm_liked_votes_by_date_info);
                
            } else if ($pvm_mv_vote_type == 2) {

                // Again Update Disliked Post Meta Table Values. 
                $pvm_disliked_votes_by_date_info = array();
                $pvm_disliked_votes_by_date_info[$vote_date] = $new_total_votes;
                update_post_meta($post_id, "pvm_disliked_votes_by_date", $pvm_disliked_votes_by_date_info);
                
            }

//                      echo $wpdb->last_query;//lists only single query
        }

        wp_reset_query();

        /* ------------------------------ REMOVE DATA FROM VOTING DATA TABLE  --------------------------------- */

        $wpdb->delete(
                $bpvm_voting_data_table, 
                array('ID' => $row_id), 
                array('%d') // Where Format 
        );

        wp_reset_query();
        
        //-------- NEW:: Start Remvoe Functions --------//
        
        
        if( $bpvm_undo_vote == 1 ) {
            
            /* --Reset Submission Counter-- */

            $meta_submission_counter = get_post_meta($post_id, "pvm_submission_counter");  // Get no of submissions from a single IP address.  

            $bpvm_user_IP = $_SERVER['REMOTE_ADDR'];

            if (is_array($meta_submission_counter[0]) && array_key_exists($bpvm_user_IP, $meta_submission_counter[0])) {

                $pvm_old_submission_counter = $meta_submission_counter[0][$bpvm_user_IP];

                $pvm_new_submission_counter = ($pvm_old_submission_counter > 0 ) ? ( $pvm_old_submission_counter - 1 ) : 0;

                $meta_submission_counter[0][$bpvm_user_IP] = $pvm_new_submission_counter;

                update_post_meta($post_id, "pvm_submission_counter", $meta_submission_counter[0]);
            }

            /* -- Remove Vote From User IP Address -- */

            $pvm_voted_ip = get_post_meta($post_id, "pvm_voted_ip");  // Get no of submissions from a single IP address.  

            if (is_array($pvm_voted_ip[0]) && sizeof($pvm_voted_ip[0]) > 1) {

                array_pop($pvm_voted_ip[0]); // remove the last id  
                update_post_meta($post_id, "pvm_voted_ip", $pvm_voted_ip);
                
            }
            
        }
        
    }

    $post_data = array();

    $post_data['status'] = 1;
    $post_data['bpvm_data_stack'] = sizeof($bpvm_data_stack);
    $post_data['loop_counter'] = $loop_counter;
    $post_data['like_vote_counter'] = $like_vote_counter;
    $post_data['total_likes'] = bpvm_get_vote_counts_meta($post_id);
    $post_data['dislike_vote_counter'] = $dislike_vote_counter;
    $post_data['total_dislikes'] = bpvm_get_vote_counts_meta($post_id,2);
    
    
    // Added in version 1.1.4
    update_post_meta($post_id, "pvm_total_votes", ( $post_data['total_likes'] + $post_data['total_dislikes'] ) );

    echo json_encode($post_data);

    die();
    
}

/* Display a notice that can be dismissed */

function bpvm_date_filter_admin_notice() {
    global $current_user;
    $user_id = $current_user->ID;
    
    delete_user_meta($user_id,  'bpvm_date_filter_notice');
    
    $location = $_SERVER['HTTP_REFERER'];
// wp_safe_redirect($location);
// exit();
    
    /* Check that the user hasn't already clicked to ignore the message */
    if (!get_user_meta($user_id, 'bpvm_date_filter_notice')) {
        echo '<div class="updated"><p>';
        printf(__('Plugin only started collecting date wise voting data from 13-10-2015. | <a href="%1$s">Got it & Hide Now</a>'), '?bpvm_voting_filter_ignore_admin_notice=0&location='.$location);
        echo "</p></div>";
    }
}

function bpvm_voting_filter_ignore_admin_notice() {
    global $current_user;
    $user_id = $current_user->ID;
    /* If user clicks to ignore the notice, add that to their user meta */
    if (isset($_GET['bpvm_voting_filter_ignore_admin_notice']) && '0' == $_GET['bpvm_voting_filter_ignore_admin_notice']) {
        add_user_meta($user_id, 'bpvm_date_filter_notice', 'true', true);
        wp_safe_redirect($_GET['location']);
        exit();
    }
}
add_action('admin_init', 'bpvm_voting_filter_ignore_admin_notice');