<?php

  //include the main class file
  if ( ! class_exists( 'BF_Admin_Page_Class') ) :    
    require_once("admin-page-class/admin-page-class.php");
 endif;
 
/**
   * configure your admin page
   */
  $config = array(    
    'menu'           => 'bwl-pvm',             //sub page to settings page
    'page_title'     => 'Option Panel',       //The name of this page 
    'capability'     => 'manage_options',         // The capability needed to view the page 
    'option_group'   => 'bwl_pvm_options',       //the name of the option to create in the database [do change]
    'id'             => 'bwl_pvm_admin_page',            // meta box id, unique per page[do change]
    'fields'         => array(),            // list of fields (can be added by field arrays)
    'local_images'   => false,          // Use local or hosted images (meta box images for add/remove)
    'use_with_theme' => false          //change path if used with theme set to true, false for a plugin or anything else for a custom path(default false).
  );  
  
  /**
   * instantiate your admin page
   */
  $options_panel = new BF_Admin_Page_Class($config);
  $options_panel->OpenTabs_container('');
  
  /**
   * define your admin page tabs listing
   */
  $bpvm_option_panel_links = array(
    'links' => array(
      'bpvm_general_options' =>  esc_html__('General','bwl-pro-voting-manager'),
      'bpvm_feedback_form_options' =>  esc_html__('Feedback Form','bwl-pro-voting-manager'),
      'bpvm_post_type_settings' =>  esc_html__('Post Type Settings','bwl-pro-voting-manager'),
      'bpvm_like_btn_options' =>  esc_html__('Like Button Options','bwl-pro-voting-manager'),
      'bpvm_dislike_btn_options' =>  esc_html__('Disike Button Options','bwl-pro-voting-manager'),
      'bpvm_result_display_options' =>  esc_html__('Result Display Options','bwl-pro-voting-manager'),
      'bpvm_tooltip_options' =>  esc_html__('Tipsy Options','bwl-pro-voting-manager'),
      'bpvm_voting_options' =>  esc_html__('Voting Options','bwl-pro-voting-manager'),
      'bpvm_role_options' =>  esc_html__('User Role Filter','bwl-pro-voting-manager'),
      'bpvm_advanced_options' =>  esc_html__('Advanced Options','bwl-pro-voting-manager')
    ));
  
  /*---   Start Custom Block For Recaptcha Addon --- --*/
  
  if( class_exists( 'BPVM_recap' ) ) {
      
      $bpvm_recap_addon_status = TRUE;
      
  }  else {
    
    $bpvm_recap_addon_status = FALSE;
    
}

  if ( $bpvm_recap_addon_status == TRUE) {
      
    $bpvm_option_panel_links['links']['bpvm_recaptcha_options'] = esc_html__('reCAPTCHA Options','bwl-pro-voting-manager');
      
  }
  
   /*---   Start Custom Block For Undo Block Addon --- --*/
  
  if( class_exists( 'BPVM_umv' ) ) {
      
      $bpvm_umv_addon_status = TRUE;
      
  }  else {
    
    $bpvm_umv_addon_status = FALSE;
    
}

  if ( $bpvm_umv_addon_status == TRUE) {
      
    $bpvm_option_panel_links['links']['bpvm_umv_options'] = esc_html__('Undo Vote Options','bwl-pro-voting-manager');
      
  }
  
  
  
    $options_panel->TabsListing($bpvm_option_panel_links);
  
  /**
   * Open Tab For General
   */
  $options_panel->OpenTab('bpvm_general_options');

  //title
  $options_panel->Title(esc_html__("General Options",'bwl-pro-voting-manager'));
    
   //Enable Font Awesome
  $options_panel->addCheckbox('pvm_fontawesome_status',array('name'=> esc_html__('Load Font Awesome ','bwl-pro-voting-manager'), 'std' => true, 'desc' => esc_html__('Turn it OFF, if the theme already loaded the Font Awesome icons.', 'bwl-pro-voting-manager')));
  
  //Display Voting Interface in Blog Page.
  $options_panel->addCheckbox('bpvm_display_auto_interface', array('name'=> esc_html__('Display voting box in blog/category/tag page? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to display voting box after the post content/excerpt.', 'bwl-pro-voting-manager')));
  
  
  //Display share button
   $options_panel->addCheckbox('pvm_disable_share_button',array('name'=> esc_html__('Disable Share Button? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to disable the share button for the like vote.', 'bwl-pro-voting-manager')));
  
  
  /**
   * Close Tab For General
   */   
  $options_panel->CloseTab();
  
  /**
   * Open Tab For Feedback
   */
  $options_panel->OpenTab('bpvm_feedback_form_options');
  
   //title
   $options_panel->Title(esc_html__("Feedback Form",'bwl-pro-voting-manager'));
  
  //Disable Feedback From For Down Vote
   $options_panel->addCheckbox('pvm_disable_feedback_status',array('name'=> esc_html__('Disable Feedback From? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to disable the feedback form for the dislike vote.', 'bwl-pro-voting-manager')));
   
  //Title Of Feedback From
  $options_panel->addText('pvm_feedback_form_title', array('name'=> esc_html__('Custom Feedback Form Title','bwl-pro-voting-manager'), 'std'=> 'Tell us how can we improve this post?' , 'desc' => esc_html__('Set custom Feedback Form title for dislike vote!', 'bwl-pro-voting-manager')));
  
  //Feedback Email to Admin
  $options_panel->addCheckbox('pvm_feedback_email_status',array('name'=> esc_html__('Send Feedback Message To Admin','bwl-pro-voting-manager'), 'std' => true, 'desc' => esc_html__('Turn it ON to send the feedback email to the site admin.', 'bwl-pro-voting-manager')));
  
  //Admin Email Address
  $options_panel->addText('pvm_feedback_admin_email', array('name'=> esc_html__('Admin Email ','bwl-pro-voting-manager'), 'std'=> get_bloginfo( 'admin_email' ), 'desc' => esc_html__('Set a valid Email address to get feedback email.', 'bwl-pro-voting-manager')));
  
  /**
   * Close Tab For Feedback
   */   
  $options_panel->CloseTab();
  
  /**
   * Open Tab For Post Type
   */
  
  $options_panel->OpenTab('bpvm_post_type_settings');
 
  $options_panel->Title(esc_html__("Available Post Types",'bwl-pro-voting-manager'));
  
  $options_panel->addParagraph(esc_html__("You can filter where you want to show automated voting interface.", 'bwl-pro-voting-manager'));
  
 $available_bpvm_post_types = bpvm_clean_custom_post_types();
 
 foreach( $available_bpvm_post_types as $bpvm_post_type_key=> $bpvm_post_type_value) :
    
    $bpvm_post_type_value = strtolower($bpvm_post_type_value);

    $bpvm_post_type_title = ucfirst ( str_replace('_', ' ', $bpvm_post_type_value) );

    $options_panel->addCheckbox('pvmpt_'.$bpvm_post_type_value,array('name'=> $bpvm_post_type_title, 'std' => true ));
 
 endforeach;
 
 $options_panel->addTextarea('pvm_additional_cpt',array('name'=> esc_html__('Additional Custom Post Types(CPT) ','bwl-pro-voting-manager'), 'desc' => esc_html__('Example: cpt_1,cpt_2,cpt_3. You can insert unlimited custom post type IDs in here.Each post type must be seperated by comma.','bwl-pro-voting-manager')));
 
  /**
   * Close Tab For Post Type
   */   
  $options_panel->CloseTab();


  /**
   * Open Tab For Like Button Settings
   */
  $options_panel->OpenTab('bpvm_like_btn_options');
  
  $options_panel->Title(esc_html__('Like Button Settings','bwl-pro-voting-manager'));

  //Like Thumb Icon.
  $options_panel->addSelect('pvm_like_thumb_icon',array('fa-thumbs-o-up'=>'Transparent Thumbs Up', 
                                                                             'fa-thumbs-up'=>'Filled Thumbs Up',
                                                                             'fa-heart-o'=>'Transparent Heart',
                                                                             'fa-heart'=>'Filled Heart',
                                                                             'fa-smile-o'=>'Smile Face',
                                                                             'fa-level-up'=>'Level up',
                                                                             'fa-arrow-circle-up'=>'Circle up',
                                                                             'fa-arrow-up'=>'Arrow up',
                                                                             'fa-angle-up'=>'Angle up',
                                                                             'fa-angle-double-up'=>'Double Angle up'),
          
                                array('name'=> esc_html__('Like Thumb Icon','bwl-pro-voting-manager'), 'std'=> array('fa-thumbs-o-up'), 'desc' => esc_html__('Select like vote icon.', 'bwl-pro-voting-manager')));
 
  
  //Like Thumb Color
  $options_panel->addColor('pvm_like_thumb_color',array('name'=> esc_html__('Like Thumb Color','bwl-pro-voting-manager'), 'std' => '#1E73BE',  'desc' => esc_html__('Choose like vote icon color.', 'bwl-pro-voting-manager')));

  //Like Thumb BG Color
  $options_panel->addColor('pvm_like_thumb_bg_color',array('name'=> esc_html__('Like Thumb BG Color','bwl-pro-voting-manager'), 'std' => '#FFFFFF',  'desc' => esc_html__('Choose like vote icon background color.', 'bwl-pro-voting-manager')));
  
   //Like Thumb Hover Color
  $options_panel->addColor('pvm_like_thumb_hover_color',array('name'=> esc_html__('Like Thumb Hover Color','bwl-pro-voting-manager'), 'std' => '#1E73BE',  'desc' => esc_html__('Choose like vote hover icon color.', 'bwl-pro-voting-manager')));

  //Like Thumb Hover BG Color
  $options_panel->addColor('pvm_like_thumb_hover_bg_color',array('name'=> esc_html__('Like Thumb Hover BG Color','bwl-pro-voting-manager'), 'std' => '#F2F2F2',  'desc' => esc_html__('Choose like vote icon hover background color.', 'bwl-pro-voting-manager')));
  
  //Like Custom Icon.
  $pvm_like_conditinal_fields[] = $options_panel->addImage('pvm_custom_like_icon',array('name'=> esc_html__('Upload Like Icon ','bwl-pro-voting-manager')),true);
 
  //conditinal block
  $options_panel->addCondition('pvm_like_conditinal_fields',
      array(
        'name' => esc_html__('Upload Custom Like Icon? ','bwl-pro-voting-manager'),
        'desc' => esc_html__('You can upload custom icon for like button. Best size 16x16 PX','bwl-pro-voting-manager'),
        'fields' => $pvm_like_conditinal_fields,
        'std' => false
      ));
  
   /**
   * Close Tab For Like Button Settings
   */ 
  $options_panel->CloseTab();
  
  /**
   * Open Tab For Dislike Button Settings
   */
  $options_panel->OpenTab('bpvm_dislike_btn_options');
  
  $options_panel->Title(esc_html__('Dislike Button Settings','bwl-pro-voting-manager'));
  
   //Disable Down Vote
   $options_panel->addCheckbox('pvm_disable_down_vote_status',array('name'=> esc_html__('Disable Dislike/Down Vote? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to disable the dislike vote.', 'bwl-pro-voting-manager')));
   
  //dislike Thumb Icon.
  $options_panel->addSelect('pvm_dislike_thumb_icon',array('fa-thumbs-o-down'=>'Transparent Thumbs Down', 
                                                                                'fa-thumbs-down'=>'Filled Thumbs Down',
                                                                                'fa-frown-o'=>'Sad Face ',
                                                                                'fa-level-down'=>'Level Down',
                                                                                'fa-arrow-circle-down'=>'Circle Down',
                                                                                'fa-arrow-down'=>'Arrow Down',
                                                                                'fa-angle-down'=>'Angle Down',
                                                                                'fa-angle-double-down'=>'Double Angle Down'),
          
                                array('name'=> esc_html__('Dislike Thumb Icon','bwl-pro-voting-manager'), 'std'=> array('fa-thumbs-o-down')));
  
  //Dislike Thumb field
  $options_panel->addColor('pvm_dislike_thumb_color',array('name'=> esc_html__('Dislike Thumb Color ','bwl-pro-voting-manager'), 'std' => '#FF4828',  'desc' => esc_html__('Choose dislike vote icon color.', 'bwl-pro-voting-manager')));
  
  //Dislike Thumb  BG Color
  $options_panel->addColor('pvm_dislike_thumb_bg_color',array('name'=> esc_html__('Dislike Thumb BG Color','bwl-pro-voting-manager'), 'std' => '#FFFFFF',  'desc' => esc_html__('Choose dislike vote icon background color.', 'bwl-pro-voting-manager')));
  
  //Dislike Thumb Hover Color
  $options_panel->addColor('pvm_dislike_thumb_hover_color',array('name'=> esc_html__('Dislike Thumb Hover Color','bwl-pro-voting-manager'), 'std' => '#FF4828',  'desc' => esc_html__('Choose dislike vote hover icon color.', 'bwl-pro-voting-manager')));

  //Dislike Thumb Hover BG Color
  $options_panel->addColor('pvm_dislike_thumb_hover_bg_color',array('name'=> esc_html__('Dislike Thumb Hover BG Color','bwl-pro-voting-manager'), 'std' => '#F2F2F2',  'desc' => esc_html__('Choose dislike vote icon hover background color.', 'bwl-pro-voting-manager')));
  
  //Dislike Custom Icon.
  $pvm_dislike_conditinal_fields[] = $options_panel->addImage('pvm_custom_dislike_icon',array('name'=> esc_html__('Upload Dislike Icon ','bwl-pro-voting-manager')),true);

  //conditinal block
  $options_panel->addCondition('pvm_dislike_conditinal_fields',
      array(
        'name' => esc_html__('Upload Custom Dislike Icon? ','bwl-pro-voting-manager'),
        'desc' => esc_html__('You can upload custom icon for dislike button. Best size 16x16 PX','bwl-pro-voting-manager'),
        'fields' => $pvm_dislike_conditinal_fields,
        'std' => false
      ));
  
  
  
  /**
   * Close Tab For Dislike Button Settings
   */ 
  $options_panel->CloseTab();
  
  
  /**
   * Open Tab For Result Display
   */
  $options_panel->OpenTab('bpvm_result_display_options');
 
 $options_panel->Title(esc_html__("Result Display Options",'bwl-pro-voting-manager'));
 
 //Result In Percentage Mode
  $options_panel->addCheckbox('pvm_display_result_percentage',array('name'=> esc_html__('Display Result In Percentage Mode? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to display the like & dislike votes count in percentage format.', 'bwl-pro-voting-manager')));
 
 //Disable Voting Bar?
  $options_panel->addCheckbox('pvm_disable_voting_bar_status',array('name'=> esc_html__('Disable Voting Bar? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to hide the like & dislike voting result bar.','bwl-pro-voting-manager')));

  //Like Bar Color
  $options_panel->addColor('pvm_like_bar_color',array('name'=> esc_html__('Like Bar Color','bwl-pro-voting-manager'), 'std' => '#1E73BE',  'desc' => esc_html__('Set custom color for like voting bar.','bwl-pro-voting-manager')));
  
 //Dislike Bar Color
  $options_panel->addColor('pvm_dislike_bar_color',array('name'=> esc_html__('Dislike Bar Color ','bwl-pro-voting-manager'), 'std' => '#FF4828',  'desc' => esc_html__('Set custom color for dislike voting bar.','bwl-pro-voting-manager')));
  
  
  /**
   * Close Tab For Result Display
   */   
  $options_panel->CloseTab();
  
  
  /**
   * Open Tab For Tooltip Options.
   */
  $options_panel->OpenTab('bpvm_tooltip_options');

  //title
  $options_panel->Title(esc_html__("Tool Tip Options",'bwl-pro-voting-manager'));
  
  //Disable Tipsy
  $options_panel->addCheckbox('pvm_tipsy_status',array('name'=> esc_html__('Show Tool Tip ','bwl-pro-voting-manager'), 'std' => TRUE, 'desc' => esc_html__('Turn it OFF to disable the Like & Dislike tooltip.','bwl-pro-voting-manager')));

  //Tipsy Like Hover Title
  $options_panel->addText('pvm_tipsy_like_title', array('name'=> esc_html__('Like Hover Title','bwl-pro-voting-manager'), 'std'=> esc_html__('Like The Post', 'bwl-pro-voting-manager') , 'desc' => esc_html__('Set custom tooltip text for like button.','bwl-pro-voting-manager')));
  
  //Tipsy Dislike Hover Title
  $options_panel->addText('pvm_tipsy_dislike_title', array('name'=> esc_html__('Dislike Hover Title','bwl-pro-voting-manager'), 'std'=> esc_html__('Dislike The Post', 'bwl-pro-voting-manager') , 'desc' => esc_html__('Set custom tooltip text for dislike button.','bwl-pro-voting-manager')));
  
  //Tipsy Background
  $options_panel->addColor('pvm_tipsy_bg',array('name'=> esc_html__('Tool Tip Background','bwl-pro-voting-manager'), 'std' => '#000000',  'desc' => esc_html__('Set tooltip background color.','bwl-pro-voting-manager')));

   //Tipsy Background
   $options_panel->addColor('pvm_tipsy_text_color',array('name'=> esc_html__('Tool Tip Text Color','bwl-pro-voting-manager'), 'std' => '#FFFFFF',  'desc' => esc_html__('Set tooltip text color.','bwl-pro-voting-manager')));
  
  /**
   * Close Tab For Tooltip Options.
   */   
  $options_panel->CloseTab();
  
  
  /**
   * Open Tab For Voting Options.
   */
  $options_panel->OpenTab('bpvm_voting_options');
  
  $options_panel->Title(esc_html__("Voting Options",'bwl-pro-voting-manager'));
  
  $options_panel->addCheckbox('pvm_login_status',array('name'=> esc_html__('Login Required? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to allow voting for the logged in users.','bwl-pro-voting-manager')));
  
  //Filter IP Address.
  $options_panel->addCheckbox('pvm_ip_filter_status',array('name'=> esc_html__('IP Filter Status: ','bwl-pro-voting-manager'), 'std' => TRUE, 'desc' => esc_html__('Turn it OFF to allow multiple votes from single IP.','bwl-pro-voting-manager')));
  
  //is_numeric
  $options_panel->addText('pvm_vote_interval',
    array(
      'name'   => esc_html__('Voting Interval ','bwl-pro-voting-manager'),
      'std'     => '120',
      'desc'   => __("e.g: we set 120 min(2 hours) interval between repeated votes for a post. <br /><b>Requirement : </b><br />Turn <b>ON</b> IP Filter Status.",'bwl-pro-voting-manager'),
      'validate' => array(
          'numeric' => array('param' => '','message' => esc_html__("must be number. e.g: 120",'bwl-pro-voting-manager'))
      )
    )
  );
  
  //is_numeric
  $options_panel->addText('pvm_max_vote_submission',
    array(
      'name'     => esc_html__('Maximum no of Votes between Interval ','bwl-pro-voting-manager'),
      'std'      => '1',
      'desc'     => __("Set the number of repeat votes that a user can submit from an IP address between the interval time. <b>Example</b>- If the Maximum Vote value set as <b>3</b> and Voting Interval value <b>120 MIN</b>, then user can submit maximum 3 votes from the same IP address for 120 MIN. <br /><b>Requirement : </b><br /> Turn <b>ON</b>  IP Filter Status & Set Voting Interval Value.",'bwl-pro-voting-manager'),
      'validate' => array(
          'numeric' => array('param' => '','message' => esc_html__("must be number. e.g: 1",'bwl-pro-voting-manager'))
      )
    )
  );
  
  $options_panel->addCheckbox('bpvm_vote_once_status',
          array('name'=> esc_html__('Enable Single Vote Option ','bwl-pro-voting-manager'), 'std' => FALSE, 
              'desc' => 'Turn it ON to allow only one vote for a post (not multiple posts) for the entire site. <br /><b>Requirement : </b><br />Turn <b>ON</b> IP Filter Status.')
          );
  
    /**
   * Close Tab For Voting Options.
   */   
  $options_panel->CloseTab();
  
  
  /**
   * Open Tab For Role Options.
   */
  $options_panel->OpenTab('bpvm_role_options');
  
  $options_panel->Title(esc_html__("User Role Filter",'bwl-pro-voting-manager'));
   
    if (!function_exists('get_editable_roles')) {
        require_once( ABSPATH . '/wp-admin/includes/user.php' );
    }
    $bpvm_all_user_roles = get_editable_roles();
    $bpvm_filter_user_roles = array();

    if (sizeof($bpvm_all_user_roles) > 0):
        foreach ($bpvm_all_user_roles as $role_id => $role_info) :
            $bpvm_filter_user_roles[$role_id] = $role_info['name'];
        endforeach;
    endif;
  
  //Required Login To Submit Vote
  $pvm_role_filter_fields[] = $options_panel->addRoles('pvm_enabled_roles',array('type' => 'checkbox_list' ),array('name'=> esc_html__('Available Roles','bwl-pro-voting-manager')),true);

  $options_panel->addCondition('pvm_role_status',
      array(
        'name'   => esc_html__('Enable Role Filter','bwl-pro-voting-manager'),
        'desc'   => esc_html__('Turn it ON to allow submit votes for the particular user roles.','bwl-pro-voting-manager'),
        'fields' => $pvm_role_filter_fields,
        'std'    => false
      ));
  
    /**
   * Close Tab For Role Options.
   */   
  $options_panel->CloseTab();
  
  
   /**
   * Open Tab For Advance
   */
  $options_panel->OpenTab('bpvm_advanced_options');
 
 $options_panel->Title(esc_html__("Advance Setting",'bwl-pro-voting-manager'));
 
 $options_panel->addCode('pvm_custom_css',array('name'=> esc_html__('Custom CSS ','bwl-pro-voting-manager'), 'syntax' => 'css', 'desc' => esc_html__('Add custom css code in here.','bwl-pro-voting-manager')));
  
  /**
   * Close Tab For Advance
   */   
  $options_panel->CloseTab();
  
  
   if ( $bpvm_recap_addon_status == TRUE) {
  
  /**
   * Open Tab For reCAPTCHA Options
   */
  $options_panel->OpenTab('bpvm_recaptcha_options');
  
   //title
   $options_panel->Title(esc_html__("reCAPTCHA Options",'bwl-pro-voting-manager'));
  
  //Disable Feedback From For Down Vote
   $options_panel->addCheckbox('bpvm_recaptcha_status',array('name'=> esc_html__('Enable reCAPTCHA? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to enable the reCAPTCHA feature.', 'bwl-pro-voting-manager')));
   
  //Title Of Feedback From
      $options_panel->addText('bpvm_recaptcha_site_key', array('name'=> esc_html__('reCAPTCHA Site Key','bwl-pro-voting-manager'), 'std'=> '' , 'desc' => esc_html__('Add a valid reCAPTCHA v2 Site Key.', 'bwl-pro-voting-manager'). ' <a href="https://www.google.com/recaptcha" target="_blank">Get Your Key</a>' ) );
  
  /**
   * Close Tab For Feedback
   */   
  $options_panel->CloseTab();
  
}

 if ( $bpvm_umv_addon_status == TRUE) {
  
  /**
   * Open Tab For Undo My Vote Options
   */
  $options_panel->OpenTab('bpvm_umv_options');
  
   //title
   $options_panel->Title(esc_html__("Undo Vote Options",'bwl-pro-voting-manager'));
  
  //Disable Feedback From For Down Vote
   $options_panel->addCheckbox('bpvm_umv_status',array('name'=> esc_html__('Enable Undo Vote Option? ','bwl-pro-voting-manager'), 'std' => FALSE, 'desc' => esc_html__('Turn it ON to enable the undo voting feature.', 'bwl-pro-voting-manager')));
   
  //Title Of Feedback From
      $options_panel->addText('bpvm_umv_max_count', array('name'=> esc_html__('Max no of allowed undo votes?','bwl-pro-voting-manager'), 'std'=> '5' , 'desc' => esc_html__("must be number. e.g: 1,2,5",'bwl-pro-voting-manager')) );
  
  /**
   * Close Tab For Feedback
   */   
  $options_panel->CloseTab();
  
}