<?php

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

//define('MY_TEST_IP', '192.168.7.70');

function bwl_pvm_set_ajax_url() {
    
     $pvm_data = get_option('bwl_pvm_options');
     
     $pvm_tipsy_status =  1;
     $pvm_disable_feedback_status =  0;
     
     if ( isset($pvm_data['pvm_tipsy_status']) && $pvm_data['pvm_tipsy_status'] == 0 ) {
         
         $pvm_tipsy_status =  0;
         
     } else {
        
         wp_enqueue_script( 'bwl-pro-voting-manager-tipsy-script' );
         
     }
     
     if ( isset($pvm_data['pvm_disable_feedback_status']) && $pvm_data['pvm_disable_feedback_status'] == 1 ) {
         
         $pvm_disable_feedback_status =  1;
         
     }
    
?>
    <script type="text/javascript">
        
         var ajaxurl = '<?php echo esc_url(admin_url('admin-ajax.php')); ?>',                
              err_feedback_msg = '<?php esc_html_e(' Please Write Your Feedback Message', 'bwl-pro-voting-manager'); ?>',
              pvm_feedback_thanks_msg = '<?php esc_html_e('Thanks for your feedback!', 'bwl-pro-voting-manager'); ?>',
              pvm_unable_feedback_msg = '<?php esc_html_e('Unable to receive your feedback. Please try again !', 'bwl-pro-voting-manager'); ?>',
              err_pvm_captcha = '<?php esc_html_e(' Incorrect Captcha Value!', 'bwl-pro-voting-manager'); ?>',
              pvm_tipsy_status = '<?php echo $pvm_tipsy_status; ?>',
              pvm_wait_msg = '<?php esc_html_e('Please Wait .....', 'bwl-pro-voting-manager'); ?>',
              pvm_disable_feedback_status = '<?php echo $pvm_disable_feedback_status; ?>';
       
    </script>

<?php

}

add_action('wp_head', 'bwl_pvm_set_ajax_url');


function get_bpvm_vote_once_status( $bpvm_share_btn, $pvm_msg_thanks = "" ) {
    
    // Here we will get all the once voted info as an array.
    // ID PATTERN: 'pvm_once_pvm_user_ip_pvm_vote_date'

    $pvm_once_voted_info = get_option('pvm_once_voted_info');

    $pvm_user_ip = $_SERVER['REMOTE_ADDR'];
    $pvm_vote_date = date_i18n('Y-m-d', false, true);

    $bpvm_once_id = 'pvm_once_' . $pvm_user_ip . '_' . $pvm_vote_date;

    if (isset($pvm_once_voted_info[$pvm_vote_date]) && in_array($bpvm_once_id, array_keys($pvm_once_voted_info[$pvm_vote_date]))) {

//        echo "EXIST";
        
        $pvm_msg_allowed_single_vote = apply_filters('pvm_msg_single_vote', esc_html__(' You are only allowed to vote for just one post per day!', 'bwl-pro-voting-manager'));
        
        $pvm_vote_checking_result = array(
                                                'status' => 1,
                                                'pvm_clear_counter' => 0,
                                                'msg' => $pvm_msg_allowed_single_vote
                                            );
        
    } else {

//        echo "NOT EXIST";
        $pvm_once_voted_info[$pvm_vote_date][$bpvm_once_id] = 'true';
        update_option('pvm_once_voted_info', $pvm_once_voted_info);
        
        $pvm_vote_checking_result = array(
                                                'status' => 0, // You can submit vote,
                                                'pvm_clear_counter' => 1,
                                                'msg' => $pvm_msg_thanks  . $bpvm_share_btn
                                            );
        
    }
    
    return $pvm_vote_checking_result;
    
}

function get_user_post_vote_info( $post_id =0, $user_id=0 ) {
    
    global $wpdb;
    $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
    $pvm_current_date = date("Y-m-d");
    $vars = array($post_id, $user_id, $pvm_current_date);

    $con_mv_post_filters = "";

    $sql = $wpdb->prepare("SELECT ID, vote_date FROM {$bpvm_voting_data_table} 
                    WHERE postid = %d 
                    AND user_id = %d 
                    AND DATE(vote_date) = %s 
                    " . $con_mv_post_filters . "
                    ORDER BY vote_date DESC", $vars);
    
    $pvm_votes_data = $wpdb->get_results($sql, ARRAY_A);
    
    $response_data = array();
    
        if( !empty($pvm_votes_data) ) {
            
            $response_data['total_votes'] = count($pvm_votes_data);
            $response_data['last_vote_date'] = $pvm_votes_data[0]['vote_date'];
            
        } else {
            $response_data['total_votes'] = 0;
            $response_data['last_vote_date'] = '';
        }
        
    return $response_data;
    
}


function get_bpvm_logged_in_user_vote_status( $bpvm_share_btn, $post_id, $pvm_msg_thanks= "" ) {
    
    // Here we will get all the once voted info as an array.
    // ID PATTERN: 'pvm_logged_voted_info_user_id_post_id'
  
    $user_id = 0;
     
    if ( is_user_logged_in() ) :
        $current_user = wp_get_current_user();
        $user_id = $current_user->ID;
    endif;
    
    $pvm_logged_voted_info = get_option('pvm_logged_voted_info'); // get info from database.
    
    $bpvm_logged_in_vote_check_id = 'pvm_logged_'. $user_id .'_'.$post_id;
    
    // Logged in users can not submit more than 1 vote.
    // Time count.
    
    
    $pvm_vote_submission_status = isset($pvm_logged_voted_info[$user_id]) && in_array($bpvm_logged_in_vote_check_id, array_keys($pvm_logged_voted_info[$user_id])) ? 1 : 0;
    
    
    $bwl_pvm_options = get_option('bwl_pvm_options');
    
    $pvm_max_vote_submission = ( isset($bwl_pvm_options['pvm_max_vote_submission'] ) && is_numeric( $bwl_pvm_options['pvm_max_vote_submission'] ) ) ? $bwl_pvm_options['pvm_max_vote_submission'] : 1; // = 1 votes.
    
    $timebeforerevote = ( isset( $bwl_pvm_options['pvm_vote_interval'] ) && is_numeric( $bwl_pvm_options['pvm_vote_interval'] ) ) ? $bwl_pvm_options['pvm_vote_interval'] : 120 ; // Default Interval = 2 hours  
    
    $get_user_post_vote_info = get_user_post_vote_info($post_id, $user_id);
    
    // Check Submission Count.
    
    if( $get_user_post_vote_info['total_votes'] < $pvm_max_vote_submission ) {
        $pvm_vote_submission_status = FALSE;
    } 
    
    // Check Date Validity.
    
    $now = time();  
    $time = strtotime( $get_user_post_vote_info['last_vote_date'] );
    
     if( round(($now - $time) / 60 ) > $timebeforerevote ) {
         $pvm_vote_submission_status = FALSE;
     }

     if ( $pvm_vote_submission_status ) {

//        echo "Information EXIST in Database";
         
         $pvm_msg_already_voted = apply_filters('pvm_msg_vote_exist', esc_html__(' You have already submitted your vote!', 'bwl-pro-voting-manager'));
        
        $pvm_vote_checking_result = array(
                                                'status' => 1,
                                                'pvm_clear_counter' => 0,
                                                'msg' => $pvm_msg_already_voted
                                            );
        
    } else {

//        echo "NOT EXIST";
        $pvm_logged_voted_info[$user_id][$bpvm_logged_in_vote_check_id] = 'true';
        update_option('pvm_logged_voted_info', $pvm_logged_voted_info);
        
        $pvm_vote_checking_result = array(
                                                'status' => 0, // You can submit vote,
                                                'pvm_clear_counter' => 1,
                                                'msg' => $pvm_msg_thanks . $bpvm_share_btn
                                            );
        
    }
    
    return $pvm_vote_checking_result;
    
}


/***********************************************************
* @Description: This function check if user already voted or not. It check by IP address and time interval settings.
* @Return: Return TRUE, If user submit vote, Return FALSE it not.
* @Last Edited AT: 09-02-2015
* @Created By: Mahbub
***********************************************************/

function bwl_pvm_check_already_voted( $post_id )  {
    
     global $post;
    
    //status 
    // 0 = not voted yet.
    // 1 = Already voted.
    // 2 = Limit Crossed.
    /*--- IP Filter Status ---*/
    
    $pvm_vote_checking_result = array();    
    $pvm_already_voted_status = TRUE;
    
    // Messages.
    
    $pvm_msg_thanks = apply_filters('pvm_msg_thanks', esc_html__(' Thanks for your vote!', 'bwl-pro-voting-manager')); 
    $pvm_msg_limit_crossed = apply_filters('pvm_msg_limit_cross', esc_html__(' Voting Limit Crossed!', 'bwl-pro-voting-manager')); 
    $pvm_msg_vote_exist = apply_filters('pvm_msg_vote_exist', esc_html__(' You have already submitted your vote!', 'bwl-pro-voting-manager'));
    
    // Retrieve current user IP  
    $ip = $_SERVER['REMOTE_ADDR'];  
//     $ip = MY_TEST_IP; // remove later.
     
    
    $bwl_pvm_options = get_option('bwl_pvm_options');
    
    $timebeforerevote = ( isset( $bwl_pvm_options['pvm_vote_interval'] ) && is_numeric( $bwl_pvm_options['pvm_vote_interval'] ) ) ? $bwl_pvm_options['pvm_vote_interval'] : 120 ; // Default Interval = 2 hours  
    
    //$pvm_max_vote_submission = ( isset($bwl_pvm_options['pvm_max_vote_submission'] ) && is_numeric( $bwl_pvm_options['pvm_max_vote_submission'] ) ) ? $bwl_pvm_options['pvm_max_vote_submission'] : 1; // = 1 votes.

    $bpvm_share_btn = ( isset($bwl_pvm_options['pvm_disable_share_button']) && $bwl_pvm_options['pvm_disable_share_button'] == 1 ) ? "" : do_shortcode('[bpvm_share post_id='.$post_id.' /]') ;
     
    $pvm_ip_filter_status = ( isset($bwl_pvm_options['pvm_ip_filter_status']) && $bwl_pvm_options['pvm_ip_filter_status'] == 1  ) ? 1 : 0;
    
    $bpvm_vote_once_status = ( isset($bwl_pvm_options['bpvm_vote_once_status']) &&  $bwl_pvm_options['bpvm_vote_once_status'] == 1 ) ? 1 : 0;
    
    $pvm_login_status = ( isset($bwl_pvm_options['pvm_login_status']) && $bwl_pvm_options['pvm_login_status'] == 1 ) ? 1: 0;
     
      // Global Voting Option. 
     
     if ( $pvm_ip_filter_status == 1 &&  $bpvm_vote_once_status == 1 ) {
     
        $pvm_vote_checking_result = get_bpvm_vote_once_status( $bpvm_share_btn, $pvm_msg_thanks );

        return $pvm_vote_checking_result;
     
     }
     
      // Loggedin Users Can Submit Only One Vote For A Post.
     
     if ( $pvm_login_status == 1 ) {
         
        $pvm_vote_checking_result = get_bpvm_logged_in_user_vote_status( $bpvm_share_btn, $post_id, $pvm_msg_thanks);
        
        return $pvm_vote_checking_result;
     
     }
  
    // Retrieve post votes IPs
     
    $like_vote_counter = bpvm_get_vote_counts_meta( $post_id );   
    $dislike_vote_counter = bpvm_get_vote_counts_meta( $post_id, 2 );  
    
    
    if( ( $like_vote_counter == "" || $like_vote_counter == 0 ) && ($dislike_vote_counter == "" || $dislike_vote_counter == 0 ) ) {
         
        $pvm_vote_checking_result = array(
                                                'status' => 0, // You can submit vote
                                                'pvm_clear_counter' => 0,
                                                'msg' => $pvm_msg_thanks   . $bpvm_share_btn
                                            );
         
         return $pvm_vote_checking_result;
        
    }
    
    /*--- End Submission Counter Checking ---*/
    
    // tag = pvm_once_13_05_2017_10_10_20_2217
    
    // If user has already voted  
    if ( $pvm_ip_filter_status == 1 ) {       
        
        /*--- Start Submission Counter Checking ---*/
    
        $pvm_limit_cross_status= bpvm_get_vote_limit_cross_status( $post_id );
    
        /*--- Start User IP Checking ---*/

        $meta_IP = get_post_meta($post_id, "pvm_voted_ip");

        if( is_array($meta_IP) && !empty($meta_IP[0])) {

            $voted_IP = $meta_IP[0];  

        } else {

             $voted_IP = array();  

        }
        
        $time = $voted_IP[$ip];
        
        $now = time();  
          
        //$bpvm_already_voted_status = in_array($ip, array_keys($voted_IP));
        
         if( round(($now - $time) / 60 ) > $timebeforerevote ) {
            
            // erase old limit cross counter.
            
            $pvm_vote_checking_result = array(
                                                'status' => 0, // You can submit vote,
                                                'pvm_clear_counter' => 1,
                                                'msg' => $pvm_msg_thanks  . $bpvm_share_btn
                                            );
            
            
        } else if( round(($now - $time) / 60 ) <= $timebeforerevote && $pvm_limit_cross_status == FALSE ) {
            
            // You can submit vote and return thank you message.
            
            $pvm_vote_checking_result = array(
                                                'status' => 0, // You can submit vote
                                                'pvm_clear_counter' => 0,
                                                'msg' => $pvm_msg_thanks  . $bpvm_share_btn
                                            );
            
        } else if( $pvm_limit_cross_status == TRUE ) {
            
            // time available for vote but limit crossed.
            
            $pvm_vote_checking_result = array(
                                                'status' => 2, // Voting Limit Crossed.
                                                'pvm_clear_counter' => 0,
                                                'msg' => $pvm_msg_limit_crossed
                                            );
            
        } else {
          
            $pvm_vote_checking_result = array(
                                                'status' => 1,
                                                'pvm_clear_counter' => 0,
                                                'msg' => $pvm_msg_vote_exist
                                            );
            
        }
        
    } else {
        
        // Default.
        // You can submit vote and return thank you message.
            
            $pvm_vote_checking_result = array(
                                            'status' => 0, // You can submit vote
                                            'pvm_clear_counter' => 0,
                                            'msg' => $pvm_msg_thanks  . $bpvm_share_btn
                                        );
    }
    
    /*--- End User IP Checking ---*/
      
    return $pvm_vote_checking_result;  
    
}


function bwl_pvm_add_rating() {
 
     if( isset($_REQUEST['count_vote']) ) {
          
        // check if user logged in or not.
        
        $pvm_data = get_option('bwl_pvm_options');
        
        $pvm_login_status = FALSE;
        
        if( isset( $pvm_data['pvm_login_status'] ) && $pvm_data['pvm_login_status']==1 ) {
            
            $pvm_login_status = FALSE;        
            
            if ( is_user_logged_in() ) :
                $pvm_login_status = TRUE;        
            endif;
            
            if( $pvm_login_status == FALSE ) {
            
                $data = array (
                    'status'            => 0,
                    'msg'               => apply_filters('pvm_msg_login_required', esc_html__(' LogIn required to submit vote!', 'bwl-pro-voting-manager'))
                );

                echo json_encode($data);
                
                die();
            
            }
            
        }
         

        /*--- START DEBUG AREA ---*/
         
         
//        $random_ip = array('192.10.10.1','192.10.10.2','192.10.10.3'); 
         
//        $ip = $random_ip[rand(0,2)];
//        $ip = '192.10.10.4';
        
        /*--- END DEBUG AREA ---*/
        
        // Retrieve user IP address  
        $pvm_voted_ip = array();
        $user_ip          =  $_SERVER['REMOTE_ADDR']; // get user IP address.
//        $ip          = MY_TEST_IP; // get user IP address.
        
        $post_id  = $_POST['post_id'];
        
        $vote_status  = $_POST['vote_status'];
        
        $meta_IP = get_post_meta($post_id, "pvm_voted_ip");  // Get voters'IPs for the current post  
        
       if (is_array ($meta_IP) && !empty($meta_IP[0]) && $meta_IP[0] !=1 )  {
           
            $pvm_voted_ip = $meta_IP[0];
            
        }
        
        // Date Wise Like Voting Counter
        // Introduced in version 1.0.9.
        // We are going to store votes by date.
        // For example: Post id is 1 and date 04-10-2015 we received 4 up votes and 5 down votes.
        
        $pvm_current_date =  date("Y-m-d");
        $pvm_current_date_time =  date("Y-m-d H:i:s");
        $pvm_liked_votes_by_date = get_post_meta( $post_id, "pvm_liked_votes_by_date" );  // Get Liked vote per date wise for the current post  
        
        if( is_array($pvm_liked_votes_by_date) && !empty($pvm_liked_votes_by_date[0]) ) {
        
            $pvm_liked_votes_by_date_info = $pvm_liked_votes_by_date[0];  

        } else {

             $pvm_liked_votes_by_date_info = array();  

        }
        
        
        if ( is_array($pvm_liked_votes_by_date) && !empty($pvm_liked_votes_by_date[0])  && in_array( $pvm_current_date, array_keys( $pvm_liked_votes_by_date[0] ) ) ) {
            
            $pvm_like_vote_update_status = 1;
            
            $pvm_liked_votes_by_date_counter = $pvm_liked_votes_by_date[0][$pvm_current_date]; // store meta submission counter value.
            $pvm_liked_votes_by_date_info[$pvm_current_date ]= $pvm_liked_votes_by_date_counter+1;
            $pvm_liked_date_wise_total_votes = $pvm_liked_votes_by_date_counter+1;

        } else {

            $pvm_like_vote_update_status = 0;   
            
            $pvm_liked_votes_by_date_counter = 0; // if no one submitted voted yet, initialize pvm_submission_counter variable.
            $pvm_liked_votes_by_date_info[$pvm_current_date ]= $pvm_liked_votes_by_date_counter+1;
            $pvm_liked_date_wise_total_votes = $pvm_liked_votes_by_date_counter+1;
        }
        
//        echo 'Like Vote Update status: '.$pvm_like_vote_update_status;
        
        
        // Date Wise DisLike Voting Counter
        // Introduced in version 1.0.9.
        // We are going to store votes by date.
        // For example: Post id is 1 and date 04-10-2015 we received 4 up votes and 5 down votes.
        
        
        $pvm_disliked_votes_by_date = get_post_meta($post_id, "pvm_disliked_votes_by_date");  // Get Disliked vote per date wise for the current post  
        
        if( is_array($pvm_disliked_votes_by_date) && !empty($pvm_disliked_votes_by_date[0])) {
        
            $pvm_disliked_votes_by_date_info = $pvm_disliked_votes_by_date[0];  

        } else {

             $pvm_disliked_votes_by_date_info = array();  

        }
        
        
        if ( is_array($pvm_disliked_votes_by_date) && !empty($pvm_disliked_votes_by_date[0]) && in_array( $pvm_current_date, array_keys( $pvm_disliked_votes_by_date[0] ) ) ) {
            
            $pvm_dislike_vote_update_status = 1;
            
            $pvm_disliked_votes_by_date_counter = $pvm_disliked_votes_by_date[0][$pvm_current_date]; // store meta submission counter value.
            $pvm_disliked_votes_by_date_info[$pvm_current_date ]= $pvm_disliked_votes_by_date_counter+1;
            $pvm_disliked_date_wise_total_votes = $pvm_disliked_votes_by_date_counter+1;

        } else {
            
            $pvm_dislike_vote_update_status = 0;
            
            $pvm_disliked_votes_by_date_counter = 0; // if no one submitted voted yet, initialize pvm_submission_counter variable.
            $pvm_disliked_votes_by_date_info[$pvm_current_date ]= $pvm_disliked_votes_by_date_counter+1;
            $pvm_disliked_date_wise_total_votes = $pvm_disliked_votes_by_date_counter+1;
        }
        
//        echo $pvm_dislike_vote_update_status;
        
        /*--- START SUBMISSON COUNTER SECTION ---*/
        
        $meta_submission_counter = get_post_meta($post_id, "pvm_submission_counter");  // Get voters'IPs for the current post  

        
        if (!empty($meta_submission_counter)) {
            
            $pvm_submission_counter = $meta_submission_counter[0]; // store meta submission counter value.
            
        } else {
            
            $pvm_submission_counter = array(); // if no one submitted voted yet, initialize pvm_submission_counter variable.
            
        }        
        
        // Two step checking.
        // IP filtering.
        // Time Interval.
        // If function return false, then we are going to insert/update value in to databse.
        
        $pvm_vote_checking_result = bwl_pvm_check_already_voted( $post_id );
        
        if( $pvm_vote_checking_result['status'] == 0 ) {
            
            $pvm_voted_ip[$user_ip] = time(); // store current server time 
            
            $post_type = get_post_type( $post_id );
              
            $like_vote_counter = bpvm_get_vote_counts_meta($post_id);

            if ( $like_vote_counter == "" ) {
                $like_vote_counter = 0;
            }

            $dislike_vote_counter = bpvm_get_vote_counts_meta($post_id, 2);

            if ( $dislike_vote_counter == "" ) {
                $dislike_vote_counter = 0;
            }
            
            $pvm_submission_counter[$user_ip] = (( isset( $pvm_submission_counter[$user_ip] ) ) ? $pvm_submission_counter[$user_ip] : 0 ) + 1; // Increment no of submission counter.
            
            /*--- Clear Hourly Vote Counter  ---*/
            
            if ( $pvm_vote_checking_result['pvm_clear_counter'] == 1 ) {
                $pvm_submission_counter[$user_ip] = 1;
            }
            
            // Save IP and increase votes count
                 
            global $wpdb;
            $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
            $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary. 
            $bpvm_data_primary_id = 0; // Get bpvm_data_primary_id
                 
            // Add USER ID.

            $user_id = 0;

            if ( is_user_logged_in() ) {

                $current_user = wp_get_current_user();
                $user_id = $current_user->ID;
                
            }

            if ( $vote_status == 1 ) {

                $total_vote_counter = $like_vote_counter+$dislike_vote_counter+1;

                // Like Vote Couter. 
                
                 update_post_meta($post_id, "pvm_liked_votes_by_date", $pvm_liked_votes_by_date_info );
                 update_post_meta($post_id, "pvm_voted_ip", $pvm_voted_ip);
                 update_post_meta($post_id, "pvm_like_votes_count", ++$like_vote_counter);
                 update_post_meta($post_id, "vote_date", date('Y-m-d'));
                 update_post_meta($post_id, "pvm_submission_counter", $pvm_submission_counter);
                 
                 // Insert Each Like Vote Entry.
                  $wpdb->insert(
                    $bpvm_voting_data_table,
                    array(
                       'postid'=>$post_id,
                       'post_type'=>$post_type,
                       'vote_type'=>1, // like=1, dislike=2
                       'votes'=> 1, // default is 1.
                       'vote_date'=> $pvm_current_date_time,
                        'voted_ip' => $_SERVER['REMOTE_ADDR'],
                        'user_id' => $user_id
                     ),
                    array ('%d','%s','%d','%d','%s','%s','%d')
                 );
                  
                  $bpvm_data_primary_id = $wpdb->insert_id; // get last id
                  
                  // Summary Section.
                  
                  if ( $pvm_like_vote_update_status == 1 ) {
                      
                      // post type and post id required.
                      
//                      echo "I'm here";
                      
                      $wpdb->update(
                        $bpvm_voting_summary_table,
                        array(
                           'total_votes'=> $pvm_liked_date_wise_total_votes, // default is 1.
                           'last_voted'=> $pvm_current_date_time
                         ), // Data – array of data to update as column->value pairs
                        array('postid'=>$post_id,'post_type'=>$post_type, 'vote_type'=> 1, 'vote_date'=> $pvm_current_date), //Where – array of data to match as column->value pairs
                        array ('%d','%s'),// Data Format 
                        array( '%d','%s', '%d','%s') // Where Format 
                     );
                      
                      
//                      echo $wpdb->last_query;
                      
                  } else {
                      
                      $wpdb->insert(
                        $bpvm_voting_summary_table,
                        array(
                           'postid'=>$post_id,
                           'post_type'=>$post_type,
                           'vote_type'=>1, // like=1, dislike=2
                           'vote_date'=> $pvm_current_date,
                           'total_votes'=> $pvm_liked_date_wise_total_votes, // default is 1.
                           'last_voted'=> $pvm_current_date_time
                         ),
                        array ('%d','%s','%d','%s','%d','%s')
                     );
                      
                  }
                  
            } else {

                $total_vote_counter = $like_vote_counter+$dislike_vote_counter+1;

                // Dislike Vote Counter
                update_post_meta($post_id, "pvm_disliked_votes_by_date", $pvm_disliked_votes_by_date_info);
                update_post_meta($post_id, "pvm_voted_ip", $pvm_voted_ip);
                update_post_meta($post_id, "pvm_dislike_votes_count", ++$dislike_vote_counter);
                update_post_meta($post_id, "vote_date", date('Y-m-d'));
                update_post_meta($post_id, "pvm_submission_counter", $pvm_submission_counter);
                 
                 // Insert Each DisLike Vote Entry.
                  $wpdb->insert(
                    $bpvm_voting_data_table,
                    array(
                       'postid'=>$post_id,
                       'post_type'=>$post_type,
                       'vote_type'=>2, // like=1, dislike=2
                       'votes'=> 1, // default is 1.
                       'vote_date'=> $pvm_current_date_time,
                        'voted_ip' => $_SERVER['REMOTE_ADDR'],
                        'user_id' => $user_id
                     ),
                    array ('%d','%s','%d','%d','%s','%s')
                 );
                  
                 $bpvm_data_primary_id = $wpdb->insert_id; // get last id

                  
                  // Summary Section.
                  
                  if ( $pvm_dislike_vote_update_status == 1 ) {
                      
                      // post type and post id required.
                      
                      $wpdb->update(
                        $bpvm_voting_summary_table,
                        array(
                           'total_votes'=> $pvm_disliked_date_wise_total_votes, // default is 1.
                           'last_voted'=> $pvm_current_date_time
                         ), // Data – array of data to update as column->value pairs
                        array('postid'=>$post_id,'post_type'=>$post_type, 'vote_type'=> 2, 'vote_date'=> $pvm_current_date), //Where – array of data to match as column->value pairs
                        array ('%d','%s'),// Data Format 
                        array( '%d','%s','%d','%s') // Where Format 
                     );
                      
                      
                  } else {
                      
                      $wpdb->insert(
                        $bpvm_voting_summary_table,
                        array(
                           'postid'=>$post_id,
                           'post_type'=>$post_type,
                           'vote_type'=>2, // like=1, dislike=2
                           'vote_date'=> $pvm_current_date,
                           'total_votes'=> $pvm_disliked_date_wise_total_votes, // default is 1.
                           'last_voted'=> $pvm_current_date_time
                         ),
                        array ('%d','%s','%d','%s','%d','%s')
                     );
                      
                  }
                
            }
            
            
            //Added percentage display option in version 1.1.5
            
            $pvm_like_vote_percentage = ceil(pvm_calculate_percentage($total_vote_counter, $like_vote_counter));
            $pvm_dislike_vote_percentage = 100-$pvm_like_vote_percentage;
            
            if (isset($pvm_data['pvm_display_result_percentage']) && $pvm_data['pvm_display_result_percentage'] == 1) {
                $like_vote_counter = $pvm_like_vote_percentage.'%';
                $dislike_vote_counter = $pvm_dislike_vote_percentage.'%';
            }
            
            /*-- Undo My Vote Addon Shortcode --*/
            
            $bpvm_umv_shortcode="";
            
            if( class_exists('BPVM_umv') && shortcode_exists('bpvm_umv')) {
                
                $bpvm_umv_vote_type =  ( $_REQUEST['vote_status'] == 0 ) ? 2 : 1;
                $bpvm_umv_vote_date = date("Y-m-d");
            
                $bpvm_umv_shortcode .= do_shortcode('[bpvm_umv title="Undo!" post_type="' . $post_type . '" post_id="' . $_POST['post_id'] . '" bpvm_data_id="' . $bpvm_data_primary_id . '" votes="1" vote_type="' . $bpvm_umv_vote_type . '" vote_date="' . $bpvm_umv_vote_date . '"]');
            
            }
            
            $data = array (
                'status'           => 1,
                'like_vote_counter' => $like_vote_counter,
                'dislike_vote_counter' => $dislike_vote_counter,
                'like_percentage' => $pvm_like_vote_percentage,
                'dislike_percentage' => $pvm_dislike_vote_percentage,
                'total_vote_counter' => $total_vote_counter,
                'vote_status'   => $vote_status,
                'msg'              => $pvm_vote_checking_result['msg'] . $bpvm_umv_shortcode
            );
            
            // Added in version 1.1.4
            update_post_meta($post_id, "pvm_total_votes", $total_vote_counter);
            
        } else if( $pvm_vote_checking_result['status'] == 1 ) {
            
             $data = array (
                'status'            => 0,
                'msg'               => $pvm_vote_checking_result['msg']
            );
             
        } else if( $pvm_vote_checking_result['status'] == 2 ) {
            
             $data = array (
                'status'            => 0,
                'msg'               => $pvm_vote_checking_result['msg']
            );
             
        } else  {
            
            // Default !
            
             $data = array (
                'status'            => 0,
                'msg'               => $pvm_vote_checking_result['msg']
            );
             
        }
        echo json_encode($data);
    }
    
    die();
    
}

add_action('wp_ajax_bwl_pvm_add_rating', 'bwl_pvm_add_rating');
add_action( 'wp_ajax_nopriv_bwl_pvm_add_rating', 'bwl_pvm_add_rating' );

/*--- Add Feedback Message ---*/

function bwl_pvm_save_post_data() {     
    
    $post_id = $_REQUEST['post_id'];
    
     if ( empty($_REQUEST) || !wp_verify_nonce($_REQUEST['name_of_nonce_field'], 'name_of_my_action') ) {
         
        $status = array(
            'pvm_feedback_status' => 0
        );
         
     } else {
    
         // We are going to create an unique ID
         
         $pvm_feedback_message_unique_id = 'pvm_feedback_list_'.$post_id; // so idea is we are going to add post id after vairable name
         
        $prev_pvm_feedback_message = ( get_post_meta($post_id, $pvm_feedback_message_unique_id, true) == "" ) ?  array() : get_post_meta($post_id, $pvm_feedback_message_unique_id, true);  
        
        $prev = $prev_pvm_feedback_message;
         
        $prev_pvm_feedback_message[] = wp_strip_all_tags( $_REQUEST['feedback_message_box'] );
        
        update_post_meta($post_id, $pvm_feedback_message_unique_id, $prev_pvm_feedback_message, $prev);
        
        //Send Email to administrator.
        
        $pvm_feedback_email_status = TRUE; // Initally We send email when user post a new faq.
        
        $bwl_pvm_options = get_option('bwl_pvm_options');
    
        if ( isset($bwl_pvm_options['pvm_feedback_email_status'] ) && $bwl_pvm_options['pvm_feedback_email_status'] == 0) { 
            
            $pvm_feedback_email_status = FALSE;
            
        }
        
        if ( $pvm_feedback_email_status == TRUE ) {
            
            $to =  get_bloginfo( 'admin_email' );
            
            if ( isset($bwl_pvm_options['pvm_feedback_admin_email'] ) && $bwl_pvm_options['pvm_feedback_admin_email'] != "") { 
            
                $to =  $bwl_pvm_options['pvm_feedback_admin_email'];

            }
            
            $email = "user@email.com";
            $subject = apply_filters('pvm_feedback_subject', esc_html__('New Feedback Submitted!', 'bwl-pro-voting-manager'));
            $edit_faq_url = get_admin_url() . "post.php?post&#61;$post_id&#38;action&#61;edit";
            
            $pvm_feedback_email_header = "<p>" . esc_html__("Hello Administrator", 'bwl-pro-voting-manager') . ",<br>" . esc_html__("A new Feedback has been submitted by a user.", 'bwl-pro-voting-manager') . "</p><hr />";
            $pvm_feedback_email_footer = "<p><strong>" . esc_html__("Review Feedback", 'bwl-pro-voting-manager') . ":</strong> " . $edit_faq_url . "<br>" . esc_html__("Thank You!", 'bwl-pro-voting-manager') . "</p>";

            $body = $pvm_feedback_email_header;
            $body .= "<p><blockquote>" . wp_strip_all_tags( $_REQUEST['feedback_message_box'] ) . "</blockquote></p>";
            $body .= $pvm_feedback_email_footer;

            $headers[] = "From: " . apply_filters('pvm_feedback_header', esc_html__('New Feedback', 'bwl-pro-voting-manager')) . " <$email>";

            add_filter( 'wp_mail_content_type', 'bwl_pvm_set_html_content_type' );
            
            wp_mail ( $to, $subject, $body, $headers );
            
            remove_filter ( 'wp_mail_content_type', 'bwl_pvm_set_html_content_type' );
            
        }
        
        $status = array(
            'pvm_feedback_status' => 1
        );

    }
    
    echo json_encode($status);
    
    die();
    
}

/**
* @Description: Add A filter for sending HTML email.
* @Created At: 08-04-2013
* @Last Edited AT: 30-06-2013
* @Created By: Mahbub
**/

 function bwl_pvm_set_html_content_type() {
   return 'text/html';
}
 
add_action('wp_ajax_bwl_pvm_save_post_data', 'bwl_pvm_save_post_data');

add_action( 'wp_ajax_nopriv_bwl_pvm_save_post_data', 'bwl_pvm_save_post_data' );