<?php

// Add to our admin_init function
add_action( 'bulk_edit_custom_box', 'bwl_pvm_quick_edit_box', 10, 2 );
add_action( 'quick_edit_custom_box', 'bwl_pvm_quick_edit_box', 10, 2 );

function bwl_pvm_quick_edit_box( $column_name, $post_type ) {

        switch ( $post_type ) {
        
                case $post_type: 
                
                        switch( $column_name ) {

                                    case 'bwl_pvm_display_status':
                                
                                ?>

                                        <fieldset class="inline-edit-col-right">
                                            <div class="inline-edit-col">
                                                <div class="inline-edit-group">
                                                    <label class="inline-edit-status alignleft">
                                                        <span class="title"><?php esc_html_e('Voting Display Status', 'bwl-pro-voting-manager'); ?></span>
                                                        <select name="bwl_pvm_display_status">
                                                            <option value="">- <?php esc_html_e('Select', 'bwl-pro-voting-manager'); ?> -</option>
                                                            <option value="0"><?php esc_html_e('Hidden', 'bwl-pro-voting-manager'); ?></option>
                                                            <option value="1"><?php esc_html_e('Show', 'bwl-pro-voting-manager'); ?></option>
                                                            <option value="2"><?php esc_html_e('Closed', 'bwl-pro-voting-manager'); ?></option>
                                                            <option value="3"><?php esc_html_e('Paused', 'bwl-pro-voting-manager'); ?></option>
                                                        </select>
                                                    </label>
                                                </div>
                                            </div>
                                        </fieldset>
                                            
                                <?php
                                            
                                    break;
                                
                                   case 'pvm_like_votes_count':
                                
                                ?>

                                        <fieldset class="inline-edit-col-right">
                                            <div class="inline-edit-col">
                                                <div class="inline-edit-group">
                                                    <label class="alignleft">
                                                            <input type="checkbox" value="0" name="pvm_like_votes_count">
                                                            <span class="checkbox-title"><?php esc_html_e('Reset Like Votes', 'bwl-pro-voting-manager'); ?></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </fieldset>
                                            
                                <?php
                                            
                                    break; 
                                
                                    case 'pvm_dislike_votes_count':
                                
                                ?>

                                    <fieldset class="inline-edit-col-right">
                                        <div class="inline-edit-col">
                                            <div class="inline-edit-group">
                                                <label class="alignleft">
                                                        <input type="checkbox" value="0" name="pvm_dislike_votes_count">
                                                        <span class="checkbox-title"><?php esc_html_e('Reset Dislike Votes', 'bwl-pro-voting-manager'); ?></span>
                                                </label>
                                            </div>
                                        </div>
                                    </fieldset>
                                            
                                <?php
                                            
                                    break;
                                        
                                }
                        
                        break;
                        
            }
        
}


// Add to our admin_init function

add_action('save_post', 'bwl_pvm_save_quick_edit_data', 10, 2);
 
function bwl_pvm_save_quick_edit_data( $post_id, $post ) {
    
    // pointless if $_POST is empty (this happens on bulk edit)
        if ( empty( $_POST ) )
                return $post_id;
                
        // verify quick edit nonce
        if ( isset( $_POST[ '_inline_edit' ] ) && ! wp_verify_nonce( $_POST[ '_inline_edit' ], 'inlineeditnonce' ) )
                return $post_id;
                        
        // don't save for autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
                return $post_id;
                
        // dont save for revisions
        if ( isset( $post->post_type ) && $post->post_type == 'revision' )
                return $post_id;
                
        switch( $post->post_type ) {
        
                case $post->post_type:
                
                        /**
                         * Because this action is run in several places, checking for the array key
                         * keeps WordPress from editing data that wasn't in the form, i.e. if you had
                         * this post meta on your "Quick Edit" but didn't have it on the "Edit Post" screen.
                         */
                    
                        $custom_fields = array( 'bwl_pvm_display_status', 'pvm_like_votes_count', 'pvm_dislike_votes_count' );
                        
                        foreach( $custom_fields as $field ) {
                        
                                if ( array_key_exists( $field, $_POST ) ) {
                                    
                                    update_post_meta( $post_id, $field, $_POST[ $field ] );
                                    
                                    // Clear All Data From Voting Summary & Voting Date Table
                                    if ( $field == 'pvm_like_votes_count' ) {
                                        
                                        //@ Added Like Votes Reset Feature & Fix Quick & Bulk Edit Issue
                                        //@ Since: version 1.1.1
                                        
                                        update_post_meta($post_id, "pvm_liked_votes_by_date", array() );
                                        update_post_meta($post_id, "pvm_voted_ip", "");
                                        update_post_meta($post_id, "vote_date", "");

                                        //@ Reset Like Votes In Custom Table Voting Data
                                        //@ Since: Version 1.1.0

                                        bpvm_reset_voting_data( $post->post_type, $post_id, 1 );
                                        
                                    } else  if ( $field == 'pvm_dislike_votes_count' ) {
                                        
                                        //@ Added Dislike Votes Reset Feature & Fix Quick & Bulk Edit Issue
                                        //@ Since: version 1.1.1
                                        
                                        update_post_meta($post_id, "pvm_disliked_votes_by_date", array() );
                                        update_post_meta($post_id, "pvm_voted_ip", "");
                                        update_post_meta($post_id, "vote_date", "");
                                            
                                        //@ Reset Disliked Votes In Custom Table Voting Data
                                        //@ Since: Version 1.1.0
                                        
                                        bpvm_reset_voting_data($post->post_type, $post_id, 2 );
                                    }
                                    
                                        
                                }
                                        
                        }
                                
                        break;
                        
        }
    
}


/*-----  Buik Edit -----*/

add_action( 'wp_ajax_manage_wp_posts_using_bulk_edit_pvm', 'manage_wp_posts_using_bulk_edit_pvm' );

function manage_wp_posts_using_bulk_edit_pvm() {

        // we need the post IDs
        $post_ids = ( isset( $_POST[ 'post_ids' ] ) && !empty( $_POST[ 'post_ids' ] ) ) ? $_POST[ 'post_ids' ] : NULL;
                
        // if we have post IDs
        if ( ! empty( $post_ids ) && is_array( $post_ids ) ) {
        
                // get the custom fields
            
                $custom_fields = array( 'bwl_pvm_display_status', 'pvm_like_votes_count', 'pvm_dislike_votes_count' );
                
                foreach( $custom_fields as $field ) {
                        
                        // if it has a value, doesn't update if empty on bulk
                        if ( isset( $_POST[ $field ] ) && trim( $_POST[ $field ] ) != "" ) {
                        
                                // update for each post ID
                                foreach( $post_ids as $post_id ) {
                                    
                                        update_post_meta( $post_id, $field, $_POST[ $field ] );
                                        
                                        // Clear All Data From Voting Summary & Voting Date Table
                                        if ( $field == 'pvm_like_votes_count' ) {
                                            
                                            //@ Added Like Votes Reset Feature & Fix Quick & Bulk Edit Issue
                                            //@ Since: version 1.1.1
                                            update_post_meta($post_id, "pvm_like_votes_count", 0 );
                                            update_post_meta($post_id, "pvm_liked_votes_by_date", "" );
                                            update_post_meta($post_id, "pvm_voted_ip", "");
                                            update_post_meta($post_id, "vote_date", "");
                                            
                                            //@ Reset Like Votes In Custom Table Voting Data
                                            //@ Since: Version 1.1.0
                                            
                                            bpvm_reset_voting_data( get_post_type($post_id), $post_id, 1 );
                                            
                                        } else  if ( $field == 'pvm_dislike_votes_count' ) {
                                            
                                            //@ Added Disliked Votes Reset Feature & Fix Quick & Bulk Edit Issue
                                            //@ Since: version 1.1.1
                                            update_post_meta($post_id, "pvm_dislike_votes_count", 0 );
                                            update_post_meta($post_id, "pvm_disliked_votes_by_date", "" );
                                            update_post_meta($post_id, "pvm_voted_ip", "");
                                            update_post_meta($post_id, "vote_date", "");
                                            
                                            //@ Reset Disliked Votes In Custom Table Voting Data
                                            //@ Since: Version 1.1.0
                                            
                                            bpvm_reset_voting_data( get_post_type($post_id), $post_id, 2 );
                                        }
                                        
                                }
                                
                        }
                        
                }
                
        }
        
}


function bpvm_reset_voting_data($post_type="", $post_id=0, $vote_type= "") {
    
    if ( $post_id == 0 || $post_type == "" || $vote_type == "" ) {
        return '';
    } else {
        
    // Run Row Deletion Query.

        global $wpdb;
        $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
        $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.   
     
        // Delete Details Table Data.

        $wpdb->delete(
             $bpvm_voting_data_table,
             array('post_type'=>$post_type, 'postid'=>$post_id, 'vote_type'=> $vote_type),
             array( '%s','%d', '%d') // Where Format 
         );

        // Update summary table.
        $bpvm_summary_row_exist = $wpdb->get_results("SELECT ID FROM $bpvm_voting_summary_table WHERE postid= '" . $post_id . "' AND vote_type= '" . $vote_type . "'");
        
        if ( sizeof($bpvm_summary_row_exist) > 0) {
            // Update Row
            $wpdb->delete(
                    $bpvm_voting_summary_table, 
                    array('post_type'=>$post_type, 'postid'=>$post_id, 'vote_type'=> $vote_type),
                    array( '%s','%d', '%d') // Where Format
            );
            
        }
        
        // Update total votes info.
        // Added in version 1.1.5
        
        $like_vote_counter = bpvm_get_vote_counts_meta( $post_id );   
       $dislike_vote_counter = bpvm_get_vote_counts_meta( $post_id, 2 );  
        
        $total_vote_counter = $like_vote_counter + $dislike_vote_counter;
        
        update_post_meta($post_id, "pvm_total_votes", $total_vote_counter);
        
        wp_reset_query();
        
    }
    
}

// Delete Voting Data When delete a post.
// Since: Version 1.1.3


function pvm_delete_voting_data($post_id) {

    $post_id = isset( $_GET['post'] ) ? $_GET['post'] : '';
    
    if( $post_id == "" ) {
        return '';
    }
    
    $post_type = get_post_type($post_id);
    
    global $wpdb;
    
    $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
    $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.   

    // Remove Data From Post Meta.
    delete_post_meta($post_id, "pvm_submission_counter");
    delete_post_meta($post_id, "vote_date");
    delete_post_meta($post_id, "pvm_voted_ip");
    delete_post_meta($post_id, "pvm_like_votes_count");
    delete_post_meta($post_id, "pvm_dislike_votes_count");
    delete_post_meta($post_id, "pvm_liked_votes_by_date");
    delete_post_meta($post_id, "pvm_disliked_votes_by_date");
    
    
    // Remove Data From Data Table.
    
    $wpdb->delete(
            $bpvm_voting_data_table, array('postid' => $post_id, 'post_type' => $post_type), array('%d', '%s') // Where Format 
    );

    wp_reset_query();

    // Remove Data From Summary Table.
    
    $wpdb->delete(
            $bpvm_voting_summary_table, array('postid' => $post_id, 'post_type' => $post_type), array('%d', '%s') // Where Format 
    );

    wp_reset_query();
    
}

add_action('delete_post','pvm_delete_voting_data');