<?php


// This function returns total vote counts number for like and dislike.
// Note: 1=like, 2=dislike.

function bpvm_get_vote_counts_meta( $post_id = 0, $vote_type =1 ) {    
    
    
    if( $vote_type == 2 ) {
        
        return get_post_meta($post_id, "pvm_dislike_votes_count", true); 
        
    } else {
        
        return get_post_meta($post_id, "pvm_like_votes_count", true);
    }
    
    
}

// Check if user crossed the total vote limit.

function bpvm_get_vote_limit_cross_status ( $post_id = 0 ) {
    
    $bwl_pvm_options = get_option('bwl_pvm_options');
    
    $pvm_max_vote_submission = ( isset($bwl_pvm_options['pvm_max_vote_submission'] ) && is_numeric( $bwl_pvm_options['pvm_max_vote_submission'] ) ) ? $bwl_pvm_options['pvm_max_vote_submission'] : 1; // = 1 votes.
    
    $meta_submission_counter = get_post_meta($post_id, "pvm_submission_counter");  // Get no of submissions from a single IP address.  
    
    $bpvm_user_IP = $_SERVER['REMOTE_ADDR'];  

    if (!empty($meta_submission_counter) && in_array( $bpvm_user_IP, array_keys( $meta_submission_counter[0] ) ) ) {
            
        $pvm_total_submitted_votes = $meta_submission_counter[0][$bpvm_user_IP]; // store meta submission counter value.

    } else {

        $pvm_total_submitted_votes = 0; // if no one submitted voted yet, initialize pvm_submission_counter variable.

    }
    
    $pvm_limit_cross_status= FALSE;
    
    if( $pvm_total_submitted_votes >= $pvm_max_vote_submission ) {
           
        $pvm_limit_cross_status= TRUE;

    }
    
    return $pvm_limit_cross_status;
    
}

 
function bpvm_clean_custom_post_types() {

    $available_bpvm_post_types = get_post_types();
    
     $pvm_data = get_option('bwl_pvm_options');

    // Some unset function.
    //@Updated: 1.1.1 (22-01-2015)
    
    if ( class_exists( 'TribeEvents' ) ) {

        $removed_items = array( 'attachment', 'revision', 'nav_menu_item', 'tribe_venue', 'tribe_organizer', 'product_variation', 'shop_order', 'shop_order_refund', 'shop_coupon', 'shop_webhook', 'bwl_kb');
        
    } else {
        
        $removed_items = array( 'attachment', 'revision', 'nav_menu_item', 'product_variation', 'shop_order', 'shop_order_refund', 'shop_coupon', 'shop_webhook', 'bwl_kb');
        
    }

    foreach ($removed_items as $rm_post_types_key => $rm_post_types_vlaue) {

        foreach (array_keys($available_bpvm_post_types, $rm_post_types_vlaue) as $key) {
            unset($available_bpvm_post_types[$key]);
        }
    }

    if ( class_exists( 'TribeEvents' ) ) {
        
        $available_bpvm_post_types = array_merge( array('tribe_events'=>'tribe_events'), $available_bpvm_post_types );
        
    }
    
    // Added in version 1.1.4
    // @Date: 14-08-16
    
    if( isset( $pvm_data['pvm_additional_cpt'] ) && $pvm_data['pvm_additional_cpt'] != "" ) {
//        
        
        $pvm_additional_cpt = array();
        $get_pvm_additional_cpt = explode( ',', $pvm_data['pvm_additional_cpt'] );
        
        foreach ( $get_pvm_additional_cpt as $key=> $value ) {
            
            $pvm_additional_cpt_id = trim($value);
            
            $pvm_additional_cpt[$pvm_additional_cpt_id] =  $pvm_additional_cpt_id;
            
        }

        if (is_array( $pvm_additional_cpt ) && sizeof( $pvm_additional_cpt ) > 0 ) {
            
             $available_bpvm_post_types = array_merge( $pvm_additional_cpt, $available_bpvm_post_types );
             
        }
  
    }

    return $available_bpvm_post_types;
    
}


// Plugin remove custom columns from "removed" post types.

function bpvm_admin_filter_cpt( $available_bpvm_post_types ) {
    
    $pvm_data = get_option('bwl_pvm_options');

    if (isset($available_bpvm_post_types) && sizeof($available_bpvm_post_types) > 0) {

        foreach ($available_bpvm_post_types as $post_type_key => $value) {

            $opt_post_type_key = "pvmpt_" . $post_type_key;

            if ( isset($pvm_data [$opt_post_type_key]) && $pvm_data [$opt_post_type_key] != 1) {

                unset($available_bpvm_post_types[$post_type_key]);
                
            }
        }
    }
    
    return $available_bpvm_post_types;
    
}

function bpvm_get_all_post_types() {
    
    if ( class_exists( 'TribeEvents' ) ) {
        
        $bpvm_default_post_types = array('post'=> 'post', 'tribe_events'=>'tribe_events');
        
    } else {
        
        $bpvm_default_post_types = array('post'=> 'post');
        
    }
    
    $bpvm_custom_post_types = array_merge( $bpvm_default_post_types, bpvm_clean_custom_post_types() );
    
    return $bpvm_custom_post_types;
    
}

function bpvm_get_custom_column_post_types() {
    
     if ( class_exists( 'TribeEvents' ) ) {
        
        $bpvm_default_post_types = array('posts'=> 'posts', 'tribe_events'=>'tribe_events');
        
    } else {
        
        $bpvm_default_post_types = array('post'=> 'post');
        
    }
    
    
    $bpvm_custom_post_types = array_merge( $bpvm_default_post_types, bpvm_clean_custom_post_types() );
    
    return $bpvm_custom_post_types;
    
}

function bpvm_get_widget_custom_post_types() {
    
    $bpvm_default_post_types = array('post'=> 'post');
    
    $bpvm_custom_post_types = array_merge( $bpvm_default_post_types, bpvm_clean_custom_post_types() );
    
    return $bpvm_custom_post_types;
    
}

/*
 * @Description: Post Share Button.
 * @Created by: Md Mahbub Alam Khan
 * @Since: 1.0.7
 * @Created at: 20-02-2015
 * @Last Update: 20-02-2015
 *  */

add_shortcode('bpvm_share', 'bpvm_share');

function pvm_calculate_percentage( $num_total=0, $num_amount=0  ) {
  
    if($num_amount == 0) {
        
        return 0;
        
    }
 
    $count1 = $num_amount / $num_total;
    $count2 = $count1 * 100;
    $count = number_format($count2, 4);
    return $count;
    
}

function bpvm_share( $atts ) {
    
    extract(shortcode_atts(array(
        'post_id' => ''
    ), $atts));

    $bpvm_post_title = get_the_title( $post_id );
    $bpvm_post_url = get_permalink( $post_id );
    
    return '<br /><span class="bpvm-share-links"> <strong>' .esc_html__('Share : ', 'bwl-pro-voting-manager') .'</strong>&nbsp;  

                        <a class="btn-share pvm_share" href="https://twitter.com/share?url='.$bpvm_post_url.'&amp;text='.$bpvm_post_title.'" title="Tweet It">
                           <i class="fa fa-twitter"></i>
                        </a>

                        <a class="btn-share pvm_share" href="http://www.facebook.com/sharer.php?u='.$bpvm_post_url.'" title="Share at Facebook">
                             <i class="fa fa-facebook"></i>
                        </a>

                        <a class="btn-share pvm_share" href="http://pinterest.com/pin/create/button/?url='.$bpvm_post_url.'" title="Share at Pinterest">
                            <i class="fa fa-pinterest"></i>
                        </a>

                        <a class="btn-share pvm_share" href="http://www.linkedin.com/shareArticle?mini=true&amp;url='.$bpvm_post_url.'" title="Share at LinkedIn">
                             <i class="fa fa-linkedin"></i>
                        </a>

                        <a class="btn-share pvm_share" href="http://www.tumblr.com/share/link?url='.$bpvm_post_url.'&amp;name='.$bpvm_post_title.'" title="Share at Tumblr">
                            <i class="fa fa-tumblr"></i>
                        </a>

                        <a class="btn-share" href="mailto:?subject='.$bpvm_post_title.'&amp;body='.$bpvm_post_url.'" title="Share via Email">
                             <i class="fa fa-envelope-o"></i>
                        </a>

            </span>';
    
}

function bpvm_change_date_format( $custom_date ) {
    
    if (empty($custom_date)) {
        return $custom_date;
        
    } else {

        $explode_custom_date = explode("/", $custom_date);
        return $explode_custom_date[1] . '/' . $explode_custom_date[0] . '/' . $explode_custom_date[2];
    
    }
    
}

// Added in version 1.1.4

add_action('save_post', 'pvm_init_post_vote_count');

function pvm_init_post_vote_count( $post_id ) {
      
         global $post;
        
         if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
            
             return $post_id;  
             
         } else {
             
             $post_id = get_the_ID();
             
             $pvm_like_votes_count = get_post_meta($post_id, 'pvm_like_votes_count', true);
             
             if( $pvm_like_votes_count == "" ) {
                 
                 // Update following post metas.
                 
                update_post_meta($post_id, 'pvm_like_votes_count', 0);
                update_post_meta($post_id, "pvm_liked_votes_by_date", "" );
                
                update_post_meta($post_id, 'pvm_dislike_votes_count', 0);
                update_post_meta($post_id, "pvm_disliked_votes_by_date", "" );
                
                update_post_meta($post_id, "pvm_voted_ip", "");
                update_post_meta($post_id, "vote_date", "");
                update_post_meta($post_id, 'pvm_total_votes', 0);
                
                // Enter Deafult Voting data in to custom table.
                
                global $wpdb;
                
                $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.   
                
                //Insert  Default Data
                
                $pvm_mv_date = date("Y-m-d");
                $post_type = get_post_type($post_id);
                
                $pvm_mv_vote_type = 1; // for like
                $pvm_manual_votes = 0;

                $wpdb->insert(
                        $bpvm_voting_summary_table, array(
                            'postid' => $post_id,
                            'post_type' => $post_type,
                            'vote_type' => $pvm_mv_vote_type, // like=1, dislike=2
                            'vote_date' => $pvm_mv_date,
                            'total_votes' => $pvm_manual_votes, // default is 1.
                            'last_voted' => $pvm_mv_date . ' ' . date("H:i:s")
                        ), array('%d', '%s', '%d', '%s', '%d', '%s')
                );
                
                $pvm_mv_vote_type = 2; // for dislike
                
                $wpdb->insert(
                        $bpvm_voting_summary_table, array(
                            'postid' => $post_id,
                            'post_type' => $post_type,
                            'vote_type' => $pvm_mv_vote_type, // like=1, dislike=2
                            'vote_date' => $pvm_mv_date,
                            'total_votes' => $pvm_manual_votes, // default is 1.
                            'last_voted' => $pvm_mv_date . ' ' . date("H:i:s")
                        ), array('%d', '%s', '%d', '%s', '%d', '%s')
                );
                 
             }
             
         }
}

function bpvm_insert_data( $db_table="", $query_data= ""){
   
    global $wpdb;
 
    $post_type = get_post_type($post_id);
    $vote_type = 1;
    $vote_date = date_i18n('Y-m-d H:i:s', false, true);
    $inserted = $wpdb->insert(
         'wp_bpvm_data',
         array(
            'postid'=>$post_id,
            'post_type'=>$post_type,
            'vote_type'=>$vote_type,
            'votes'=> 1,
            'vote_date'=> $vote_date
          ),
         array (
            '%d',
            '%s',
            '%d',
            '%d',
            '%s'
         )
     );
     if( $inserted ){
        echo $insert_id = $wpdb->insert_id;
     }else{
        //Insert failed
     }
}