<?php
/*
Plugin Name: BWL Pro Voting Manager
Plugin URI: https://1.envato.market/bpvm-wp
Description: BWL Pro Voting Manager provide you a great option to add automatically a custom voting system in single post. Feedback option gives you a nice way to collect user feedback and improve your post.
Author: Md Mahbub Alam Khan
Version: 1.2.7
WP Requires at least: 5.0+
Author URI: https://1.envato.market/bpvm-wp
 Text Domain: bwl-pro-voting-manager
*/

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

register_activation_hook( __FILE__, array( 'BWL_Pro_Voting_Manager' , 'bpvm_create_custom_table' ) );
 
Class BWL_Pro_Voting_Manager{
    
    function __construct() {
        
         /*--- PLUGIN COMMON CONSTANTS ------*/
        define( "BWL_PVM_PLUGIN_TITLE", 'BWL Pro Voting Manager');
        define( "BWL_PVM_PLUGIN_ROOT", 'bwl-pro-voting-manager' );
        define( "BWL_PVM_PLUGIN_DIR", plugins_url() .'/bwl-pro-voting-manager/' );
        define( "BWL_PVM_PLUGIN_VERSION", '1.2.7');
        define( "PVM_DB_TABLE_UPDATE", 'pvm_db_update_111');
        define( "BWL_PVM_PRODUCTION", 0);
        
        // @introduced in version 1.1.1
        $this->bpvm_version_manager(BWL_PVM_PLUGIN_VERSION);
        
        // Upgrade data table
        //Since: Version 1.1.0
        $this->bpvm_upgrade_db_table();
        
        // Call Immediatly Initialized.
        $this->included_files();
        
        //@Description: Load Only Admin Scripts.
        //@Since: 1.0.0

        add_action('wp_enqueue_scripts', array(&$this, 'bpvm_enqueue_scripts'));

        //@Description: Load Only Admin Scripts.
        //@Since: 1.0.0
        add_action('admin_enqueue_scripts', array($this, 'bpvm_admin_enqueue_scripts'));

        $this->bpvm_cau();
        
        //@Description: Load Only Admin Scripts.
        //@Since: 1.0.0
//        add_action('admin_init', array($this, 'bpvm_cau'));
        
        //Update vote data
        //@Since: version 1.1.2
        $this->pvm_upgrade_plugin_data();
        
        //@Added IP Columns in version 1.1.2
        $this->pvm_add_ip_columns();
        
        //@Added User Id Columns in version 1.1.2
        $this->pvm_add_user_id_column();
        
    }
    
    //Added IP Column to collect each votes IP.
    
    function pvm_add_ip_columns() {
        
         // First we need to check if the patch already applied or not.
        $pvm_upgrade_ip_columns = get_option( 'pvm_db_upgrade_112');
        
         if ( $pvm_upgrade_ip_columns != 1 ) {
             
             global $wpdb;
             
            $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
           
            //@Data Table Status.
            $pvm_dt_table_status = $wpdb->get_row("SELECT * FROM ".$bpvm_voting_data_table);
            
            if(!isset($pvm_dt_table_status->voted_ip)){
                $wpdb->query("ALTER TABLE ". $bpvm_voting_data_table ." ADD voted_ip VARCHAR(24) NOT NULL AFTER vote_date");
            }
    
             //@Finally Update DB upgrade status.
             update_option( 'pvm_db_upgrade_112', 1 );
         }
         
    }
    
    function pvm_add_user_id_column() {


        // First we need to check if the patch already applied or not.
        $pvm_user_columns = get_option('pvm_db_upgrade_200');

        if ($pvm_user_columns != 1) {

            global $wpdb;

            $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
            //@Data Table Status.
            $pvm_dt_table_status = $wpdb->get_row("SELECT * FROM " . $bpvm_voting_data_table);

            if (!isset($pvm_dt_table_status->user_id)) {
                //                ALTER TABLE `wp_bpvm_data` ADD `user_id` INT NOT NULL DEFAULT '0' AFTER `voted_ip`; 
                $wpdb->query("ALTER TABLE " . $bpvm_voting_data_table . " ADD user_id INT NOT NULL DEFAULT '0' AFTER voted_ip");
            }

            //@Finally Update DB upgrade status.
            update_option('pvm_db_upgrade_200', 1);
        }
    }

    // We are going to update summary table data.
    // Which is very important.
    // Fixed in version 1.1.2
    
    function pvm_upgrade_plugin_data() {
        
        
            // First we need to check if the patch already applied or not.
           $pvm_upgrade_plugin_data_status = get_option( 'pvm_patch_112');
            
           // If its return 1 then we assume patch already installed.
            if ( $pvm_upgrade_plugin_data_status != 1 ) {
                
                // Get available custom Post Types installed in to system.
                $pvm_available_post_types = bpvm_clean_custom_post_types();
                
                global $wpdb;

                // We need this two custom tables.
                
                $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary. 
                $bpvm_voting_details_table = $wpdb->prefix . "bpvm_data"; // Details Data.
                
                // Then create a loop for each custom post type.
                
                foreach ( $pvm_available_post_types as $post_type_key=>$post_type_name ) {
                    
                    
                 //Step 01; First we need to get summary table data. We pick postid, vote date and total votes from that table.
                 // Where clauses are: post type and vote type.
                 // st = summary table.
                 // dt = data table.
                  
                     /*--- Like Section ------*/
                    
                $st_custom_like_query = "SELECT postid, vote_date, total_votes From ".$bpvm_voting_summary_table." WHERE ".$bpvm_voting_summary_table.".vote_type=1 AND wp_bpvm_summary.post_type='".$post_type_name."' order by vote_date DESC";
                $st_custom_like_query_results = $wpdb->get_results($st_custom_like_query, ARRAY_A);

                    // If no data available in to summary table then we do not need to go inside and check in to data table.
                
                    if ( count($st_custom_like_query_results) > 0 ) {

                        foreach ($st_custom_like_query_results as $result) {

                            $postid = $result['postid']; // get post id.
                            $post_type = $post_type_name; // get post type.
                            $vote_type = 1; // get vote type.
                            $total_votes = $result['total_votes']; // get total votes and we will match the total votes with data table total votes.
                            $vote_date = $result['vote_date']; // vote date
                
                            // Now update each post total vote data
                            
                            $dt_custom_like_query = "SELECT SUM(votes) as DTV From `".$bpvm_voting_details_table."` WHERE vote_type=1 AND DATE(vote_date)='".$vote_date."' AND postid=".$postid." AND post_type = '".$post_type_key."'";
                            $dt_custom_like_query_results = $wpdb->get_results($dt_custom_like_query, ARRAY_A);
                            
                            // Checking if array is empty or not.
                            
                            if ( count($dt_custom_like_query_results)> 0 ) {
                                
                                // There we are going to do another matching.
                                
                                if ( $total_votes != $dt_custom_like_query_results[0]['DTV'] ) {
                                    // We will update summary table data by $dt_custom_like_query_results.
                                    $st_like_update_args = array(
                                                                           'postid'=>$postid,
                                                                           'post_type'=>$post_type,
                                                                           'vote_type'=> $vote_type, // like=1, dislike=2
                                                                           'vote_date'=> $vote_date
                                                                         );

                                    $wpdb->update(
                                        $bpvm_voting_summary_table,
                                        array(
                                           'total_votes'=> $dt_custom_like_query_results[0]['DTV']
                                         ), // Data – array of data to update as column->value pairs
                                        $st_like_update_args,
                                        array ('%d'),// Data Format 
                                        array( '%d','%s', '%d','%s') // Where Format 
                                     );
                                    
                                }
                                
                            }
                            
                        }
                        
                    }
                    
                    wp_reset_query();

                    /*--- Dislike Section ------*/
                    
                    $st_custom_dislike_query = "SELECT postid, vote_date, total_votes From ".$bpvm_voting_summary_table." WHERE ".$bpvm_voting_summary_table.".vote_type=2 AND wp_bpvm_summary.post_type='".$post_type_name."' order by vote_date DESC";
                    $st_custom_dislike_query_results = $wpdb->get_results($st_custom_dislike_query, ARRAY_A);

                    // If no data available in to summary table then we do not need to go inside and check in to data table.
                
                    if ( count($st_custom_dislike_query_results) > 0 ) {
                        

                        foreach ($st_custom_dislike_query_results as $result) {

                            $postid = $result['postid']; // get post id.
                            $post_type = $post_type_name; // get post type.
                            $vote_type = 2; // get vote type.
                            $total_votes = $result['total_votes']; // get total votes and we will match the total votes with data table total votes.
                            $vote_date = $result['vote_date']; // vote date
                   
                            // Now update each post total vote data
                            
                            $dt_custom_dislike_query = "SELECT SUM(votes) as DTV From `".$bpvm_voting_details_table."` WHERE vote_type=2 AND DATE(vote_date)='".$vote_date."' AND postid=".$postid." AND post_type = '".$post_type_key."'";
                            $dt_custom_dislike_query_results = $wpdb->get_results($dt_custom_dislike_query, ARRAY_A);
                            
                            // Checking if array is empty or not.
                            
                            if ( count($dt_custom_dislike_query_results)> 0 ) {
                                
                                // There we are going to do another matching.
                                
                                if ( $total_votes != $dt_custom_dislike_query_results[0]['DTV'] ) {
                                    // We will update summary table data by $dt_custom_dislike_query_results.
                                    $st_dislike_update_args = array(
                                                                           'postid'=>$postid,
                                                                           'post_type'=>$post_type,
                                                                           'vote_type'=> $vote_type, // like=1, dislike=2
                                                                           'vote_date'=> $vote_date
                                                                         );

                                    $wpdb->update(
                                        $bpvm_voting_summary_table,
                                        array(
                                           'total_votes'=> $dt_custom_dislike_query_results[0]['DTV']
                                         ), // Data – array of data to update as column->value pairs
                                        $st_dislike_update_args,
                                        array ('%d'),// Data Format 
                                        array( '%d','%s', '%d','%s') // Where Format 
                                     );
                                    
                                }
                                
                            }
                            
                        }

                    }
                    
                    wp_reset_query();
            
            }

           // Update patch status.
            update_option( 'pvm_patch_112', 1 );
        
        }
        
    }
    
     function bpvm_version_manager( $latest_version ) {
        
        $current_version = get_option('bwl_pvm_plugin_version');
 
        if( $current_version == "" ) {
            
            update_option('bwl_pvm_plugin_version', $latest_version);
            
        } elseif( $current_version != $latest_version ) {
            
            update_option('bwl_pvm_plugin_version', $latest_version);
            
        } else {
            // Do nothing!
        }
        
        
    }
    
    //@Upgrade Database Tabel.
    //@Introduced in version: 1.1.0
    
    function bpvm_upgrade_db_table() {
        
        global $wpdb;
        
//        $wpdb->query( "TRUNCATE TABLE `". $wpdb->prefix . "bpvm_summary`");
        
        $pvm_db_table_data_update_status = get_option( PVM_DB_TABLE_UPDATE );
        
        // If database prefix is wp_ then everything is fine.
        // If not then we need to Rename that table name.
        
        if ( $wpdb->prefix != "wp_" &&  BWL_PVM_PLUGIN_VERSION == '1.1.1' && $pvm_db_table_data_update_status != 1 ) {
        
            $pvm_table_fix_status = $this->bpvm_fix_table_prefix_name();
            
            if ($pvm_table_fix_status == 1 ) {
                $this->pvm_update_table_data(); // Update Summary table Data.
            }
        
        }
       
        $wp_bpvm_summary_table = $wpdb->prefix . "bpvm_summary";
        
        if($wpdb->get_var("SHOW TABLES LIKE '$wp_bpvm_summary_table'") != $wp_bpvm_summary_table) {
            $this->bpvm_create_custom_table();
        }
        
    }
    
    function bpvm_fix_table_prefix_name() {
        
        global $wpdb;
        
        $bpvm_default_voting_data_table = "wp_bpvm_data"; // Default Detail Table
        $bpvm_new_voting_data_table = $wpdb->prefix . "bpvm_data"; //  New Detail Table
        
        $bpvm_default_voting_summary_table = "wp_bpvm_summary"; // Default summary Table
        $bpvm_new_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // New summary Table
         
        // Just Rename 2 Tables For Once
        $wpdb->query( "RENAME table $bpvm_default_voting_data_table TO $bpvm_new_voting_data_table");
        $wpdb->query( "RENAME table $bpvm_default_voting_summary_table TO $bpvm_new_voting_summary_table");
        
        wp_reset_query();
        
        return 1;
        
    }
    
    function pvm_update_table_data(){
    
            global $wpdb;
            
            $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary. 
            
            $bpvm_posts_table = $wpdb->prefix."posts";
            $bpvm_postmeta_table = $wpdb->prefix."postmeta";
            
             /*---  Like ------*/
            
            $query = "SELECT post_type, post_id, meta_key, meta_value FROM `".$bpvm_posts_table."`, `".$bpvm_postmeta_table."` WHERE ".$bpvm_posts_table.".ID=".$bpvm_postmeta_table.".post_id AND `meta_key` LIKE 'pvm_liked_votes_by_date' order by post_type ASC";

            $query_results = $wpdb->get_results($query, ARRAY_A);
            foreach ($query_results as $result) {

                $post_id = $result['post_id'];
                $post_type = $result['post_type'];
                $vote_type = 1;
                $pvm_voting_data = unserialize($result['meta_value']);

                foreach ( $pvm_voting_data as $voting_data_date=> $voting_data_total ) {

                    $vote_date = $voting_data_date;
                    $last_voted =  $voting_data_date .' '. date("H:i:s");
                    $total_votes = $voting_data_total;

                    $total_votes_data = array(
                                                       'postid'=>$post_id,
                                                       'post_type'=>$post_type,
                                                       'vote_type'=> $vote_type, // like=1, dislike=2
                                                       'vote_date'=> $vote_date,
                                                       'total_votes'=> $total_votes, // default is 1.
                                                       'last_voted'=> $last_voted
                                                     );

                    $wpdb->replace(
                                $bpvm_voting_summary_table,
                                $total_votes_data,
                                array ('%d','%s','%d','%s','%d','%s')
                             );



                }
            }

            wp_reset_query();
        
        /*---  Dislike ------*/
        
        $pvm_dislike_query = "SELECT post_type, post_id, meta_key, meta_value FROM `".$bpvm_posts_table."`, `".$bpvm_postmeta_table."` WHERE ".$bpvm_posts_table.".ID=".$bpvm_postmeta_table.".post_id AND `meta_key` LIKE 'pvm_disliked_votes_by_date' order by post_type ASC";
        $pvm_dislike_query_results = $wpdb->get_results($pvm_dislike_query, ARRAY_A);
        
        foreach ($pvm_dislike_query_results as $result) {
            
            $post_id = $result['post_id'];
            $post_type = $result['post_type'];
            $vote_type = 2;
            $pvm_voting_data = unserialize($result['meta_value']);
            
            foreach ( $pvm_voting_data as $voting_data_date=> $voting_data_total ) {
                
                $vote_date = $voting_data_date;
                $last_voted =  $voting_data_date .' '. date("H:i:s");
                $total_votes = $voting_data_total;
                
                $total_votes_data = array(
                                                   'postid'=>$post_id,
                                                   'post_type'=>$post_type,
                                                   'vote_type'=> $vote_type, // like=1, dislike=2
                                                   'vote_date'=> $vote_date,
                                                   'total_votes'=> $total_votes, // default is 1.
                                                   'last_voted'=> $last_voted
                                                 );
                
                $wpdb->replace(
                            $bpvm_voting_summary_table,
                            $total_votes_data,
                            array ('%d','%s','%d','%s','%d','%s')
                         );
                
            }
            
        }
        
        wp_reset_query();
        
        update_option( PVM_DB_TABLE_UPDATE, 1 );
        
    }
    
    //Fixing Table Prefix Name.
    
    //@Custom Table For Count Votes.
    //@Introduced in version: 1.1.0
    
    public static function bpvm_create_custom_table() {
            
            global $wpdb;
            $bpvm_voting_data_table = $wpdb->prefix . "bpvm_data"; // for deatils. each day info.
            $bpvm_voting_summary_table = $wpdb->prefix . "bpvm_summary"; // daily summary.

            $sql = "CREATE TABLE $bpvm_voting_data_table (
                            ID int(11) NOT NULL AUTO_INCREMENT,
                            postid bigint(20) NOT NULL,
                            post_type varchar(200) NOT NULL,
                            vote_type int(20) DEFAULT 1,
                            votes bigint(20) DEFAULT 1,
                            vote_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                            PRIMARY KEY  (ID)
                    );
                    CREATE TABLE $bpvm_voting_summary_table (
                            ID bigint(20) NOT NULL AUTO_INCREMENT,
                            postid bigint(20) NOT NULL,
                            post_type varchar(200) NOT NULL,
                            vote_type int(20) DEFAULT 1,
                            vote_date date NOT NULL DEFAULT '0000-00-00',
                            total_votes bigint(20) NOT NULL DEFAULT 1,
                            last_voted datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                            PRIMARY KEY  (ID)
                    );";

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
        
    }
    
    // ALTER COLUMN FOR IP ADDRESS.
    
    function included_files() {
   
       add_image_size( 'pvm-post-thumb', 32, 32, true );

       require_once ( __DIR__ . '/includes/pvm-helper-functions.php');
       require_once ( __DIR__ . '/includes/pvm-interface.php');
       require_once ( __DIR__ . '/includes/pvm-vote-counter.php');
       require_once ( __DIR__ . '/includes/pvm-custom-theme.php');
        
        if( is_admin() ) {
            
            /* --- INTEGRATE FAQ TINY MCE BUTTON --- */            
            
            require_once ( __DIR__ . '/tinymce/bpvm_tiny_mce_config.php');
            require_once ( __DIR__ . '/includes/pvm-custom-column.php');
            require_once ( __DIR__ . '/includes/pvm-custom-meta-box.php');
            require_once ( __DIR__ . '/includes/pvm-quick-edit.php');
            require_once ( __DIR__ . '/option-panel/plugin-option-panel-menu.php');
            require_once ( __DIR__ . '/option-panel/plugin-voting-report-settings.php');
            require_once ( __DIR__ . '/option-panel/plugin-option-panel-settings.php');
            
        }
        
    }
    
    function bpvm_cau(){
        
//        $pvm_data = get_option('bwl_pvm_options');
//        
        if( is_admin() ) {
            
            require_once ( __DIR__ . '/includes/pvm-update-notifier.php');
        
        }
        
    }
    
    function bpvm_enqueue_scripts() {

        /* --- Load Custom Styles ---*/

         $pvm_data = get_option('bwl_pvm_options');

        wp_register_style('font-awesome', plugins_url('css/font-awesome.min.css', __FILE__));
        wp_register_style('font-shims-awesome', plugins_url('css/v4-shims.min.css', __FILE__));

        // Load Font-awesome.

        if (!isset($pvm_data['pvm_fontawesome_status']) || $pvm_data['pvm_fontawesome_status'] == 1) {

            wp_enqueue_style('font-awesome');
            wp_enqueue_style('font-shims-awesome');
        }

        wp_register_style('bwl-pro-voting-manager-styles', plugins_url('css/voting-style.css', __FILE__), array(), BWL_PVM_PLUGIN_VERSION);
        wp_enqueue_style('bwl-pro-voting-manager-styles');

        wp_register_style('bwl-pro-voting-manager-rtl-styles', plugins_url('css/voting-style-rtl.css', __FILE__), array(), BWL_PVM_PLUGIN_VERSION);

        // Load RTL Support Styling.

        if ( is_rtl() ) {

            wp_enqueue_style('bwl-pro-voting-manager-rtl-styles');
            
        }

        /* --- Load Custom Scripts ---*/

        wp_register_script('bwl-pro-voting-manager-tipsy-script', plugins_url('js/jquery.tipsy.js', __FILE__), array('jquery'), BWL_PVM_PLUGIN_VERSION, TRUE);
        wp_register_script('bwl-pro-voting-manager-custom-script', plugins_url('js/pvm-custom.js', __FILE__), array('jquery','bwl-pro-voting-manager-tipsy-script'), BWL_PVM_PLUGIN_VERSION, TRUE);
        
    }

    function bpvm_admin_enqueue_scripts(){
        
         /*--- Load Custom Styles ------*/
  
            wp_enqueue_style( 'bwl-pvm-editor-styles' , plugins_url( 'tinymce/css/bwl_pvm_editor.css' , __FILE__ ), array(), BWL_PVM_PLUGIN_VERSION );
            wp_enqueue_style( 'bwl-pvm-multiple-select-styles' , plugins_url( 'tinymce/css/multiple-select.css' , __FILE__ ), array(), BWL_PVM_PLUGIN_VERSION );
            
            wp_register_style( 'bwl-pvm-jquery-ui-style' , plugins_url( 'css/jqueryui/flick/jquery-ui-1.9.0.custom.min.css' , __FILE__ ), array(), BWL_PVM_PLUGIN_VERSION );
            wp_register_style( 'bwl-pvm-cmb-styles' , plugins_url( 'css/pvm-cmb-styles.css' , __FILE__ ), array('bwl-pvm-jquery-ui-style'));
            
            wp_register_style( 'bwl-pvm-datatables-style' , plugins_url( 'css/jquery.dataTables.css' , __FILE__ ), array('bwl-pvm-jquery-ui-style'), BWL_PVM_PLUGIN_VERSION );
            wp_enqueue_style('bwl-pvm-cmb-styles');
            
            wp_register_style( 'bwl-pvm-admin-style' , plugins_url( 'css/pvm-admin-style.css' , __FILE__ ), array('bwl-pvm-jquery-ui-style'), BWL_PVM_PLUGIN_VERSION );
            wp_enqueue_style('bwl-pvm-admin-style');
            
            /*--- Load Custom Scripts ------*/
             
            // Register Data Table & It's required codes.
            wp_register_script( 'bpvm-datatable-script', plugins_url( 'js/jquery.dataTables.min.js' , __FILE__ ) , array( 'jquery'), BWL_PVM_PLUGIN_VERSION, TRUE );
            wp_register_script( 'bpvm-admin-voting-report-script', plugins_url( 'js/pvm-admin-voting-report.js' , __FILE__ ) , array( 'jquery', 'jquery-ui-core','jquery-ui-datepicker','jquery-ui-dialog', 'bpvm-datatable-script'), BWL_PVM_PLUGIN_VERSION, TRUE );
                
            wp_register_script( 'bwl-pro-voting-manager-multiselect-script', plugins_url( 'tinymce/js/jquery.multiple.select.js' , __FILE__ ) , array( 'jquery'), BWL_PVM_PLUGIN_VERSION, TRUE );
            wp_enqueue_script( 'bwl-pro-voting-manager-multiselect-script' );
            
            wp_register_script( 'bwl-pro-voting-manager-admin-script', plugins_url( 'js/pvm-admin-custom.js' , __FILE__ ) , array( 'jquery', 'jquery-ui-core','jquery-ui-datepicker','jquery-ui-draggable', 'jquery-ui-droppable' ), BWL_PVM_PLUGIN_VERSION, TRUE );
            wp_enqueue_script( 'bwl-pro-voting-manager-admin-script' );
        
    }
    
}

/* --- Initialization ---*/

function init_bwl_pro_voting_manager() {
    new BWL_Pro_Voting_Manager();
}

add_action('init', 'init_bwl_pro_voting_manager');

require_once ( __DIR__ . '/widget/pvm-widget.php');

/* ---  TRANSLATION FILE ---*/

load_plugin_textdomain('bwl-pro-voting-manager', FALSE, dirname(plugin_basename(__FILE__)) . '/lang/');

/* --- INTEGRATE SHORTCODE   ---*/

require_once ( __DIR__ . '/shortcode/pvm-shortcodes.php');